#include "bits/stdc++.h"
using namespace std;

const long long MAX_SQUARED_DIST = 1000000000LL;
const long long OFFSET = 500000000LL;
const int MAXN = 500;

int n;
int adj[500][500];
pair<long long, long long> sol[MAXN];
vector<pair<long long, long long>> consistent_with_fst_snd[MAXN];
set<pair<long long, long long>> consistent_with_fst[MAXN];

long long int_root(long long n){
    double r = sqrt(n);
    long long res = round(r);
    if(abs(res - r) < 0.00001) return res;
    else return -1;
}

void ensure(bool cond){
    if(!cond){
        cout << "impossible" << endl;
        exit(0);
    }
}

void find_deltas_sym(int i, int j, set<pair<long long, long long>> * res){
    long long sd = adj[i][j];
    long long limit = sd;
    for(long long dx = 0; dx*dx <= limit/2; dx++){
        long long dy = int_root(sd - dx*dx);
        if(dy < 0) continue;
        res->insert({dx, dy});
    }
}

void find_deltas(int i, int j, set<pair<long long, long long>> * res){
    long long sd = adj[i][j];
    long long limit = sd;
    for(long long dx = 0; dx*dx <= limit; dx++){
        long long dy = int_root(sd - dx*dx);
        if(dy < 0) continue;
        res->insert({dx, dy});
        res->insert({dx, -dy});
        res->insert({-dx, dy});
        res->insert({-dx, -dy});
    }
}

void ensure_symmetry(){
    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            ensure(adj[i][j] == adj[j][i]);
        }
    }
}

bool is_consistent(int i, int j){
    long long mdx = sol[i].first - sol[j].first;
    long long mdy = sol[i].second - sol[j].second;
    return mdx*mdx + mdy*mdy == adj[i][j];
}

void reject(){
    cout << "impossible" << endl;
    exit(0);
}

void accept(){
    for(int i=0; i<n; i++){
        cout << sol[i].first + OFFSET << " " << sol[i].second + OFFSET << endl;
    }
    exit(0);
}

bool is_solution_consistent(){
    for(int i=0; i<n; i++){
        for(int j = 0; j<n; j++){
            if(!is_consistent(i, j)) return false;
        }
    }
    return true;
}

void accept_or_reject(){
    if(is_solution_consistent()) accept();
    else reject();
}



void place_rel(int i, int j, pair<int, int> delta){
    sol[j] = {sol[i].first + delta.first, sol[i].second + delta.second};
}

int main(){
    cin >> n;
    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            cin >> adj[i][j];
        }
    }
    ensure_symmetry();


    int fst, snd;
    int minim = 0x3f3f;

    for(int i = 0; i < min(n, 10); i++){
        for(int j = i+1; j < min(n, 10); j++){
            set<pair<long long, long long>> delta_sym;
            find_deltas_sym(i, j, &delta_sym);
            ensure(delta_sym.size() > 0);
            if(delta_sym.size() < minim){
                fst = i;
                snd = j;
                minim = delta_sym.size();
            }
        }
    }
    
    // place first object in the middle
    sol[fst] = {0, 0};

    for(int i=0; i<n; i++) {
        if(i == fst) continue;
        find_deltas(fst, i, &consistent_with_fst[i]);
        ensure(consistent_with_fst[i].size() > 0);
    }

    if(n == 2){
        place_rel(fst, snd, *consistent_with_fst[snd].begin());
        accept();
    }

    set<pair<long long, long long>> deltas_sym_snd;
    find_deltas_sym(fst, snd, &deltas_sym_snd);
    for(auto delta_snd : deltas_sym_snd){
        place_rel(fst, snd, delta_snd);

        int trd = -1;
        bool possible = true;
        for(int i=0;i<n; i++){
            if(i == fst || i == snd) continue;
            for(auto delta_i: consistent_with_fst[i]){
                place_rel(fst, i, delta_i);
                if(is_consistent(i, snd)) consistent_with_fst_snd[i].push_back(delta_i);
            }
            if(consistent_with_fst_snd[i].size() > 1) trd = i;
            if(consistent_with_fst_snd[i].size() == 0) possible = false;
        }

        if(!possible) continue;

        if(trd < 0){
            // We have a unique solution!
            for(int i=0;i<n; i++){
                if(i == snd || i == fst) continue;
                place_rel(fst, i, consistent_with_fst_snd[i][0]);
            }
            accept_or_reject();
        }

        for(auto delta_trd : consistent_with_fst_snd[trd]){
            place_rel(fst, trd, delta_trd);

            possible = true;
            for(int i=0; i<n; i++){
                if(i == fst || i == snd || i == trd) continue;
                bool placed = false;
                for(auto delta_i : consistent_with_fst_snd[i]){
                    place_rel(fst, i, delta_i);
                    if(is_consistent(trd, i)){
                        placed = true;
                        break;
                    }
                }
                if(!placed){
                    possible = false;
                    break;
                }
            }
            if(possible) accept_or_reject();
        }
    }
    reject();
    return 0;
}
