#include <cmath>
#include <iostream>
#include <vector>

using namespace std;
#define int int64_t
using vi = vector<int>;

struct pt {
	int x = 0, y = 0;
};
pt operator-(const pt& lhs, const pt& rhs)
{
	return pt { lhs.x - rhs.x, lhs.y - rhs.y };
}
int len2(const pt& x)
{
	return x.x * x.x + x.y * x.y;
}

vector<pt> find_vectors(int c_squared)
{
	vector<pt> res;
	int b = sqrt(c_squared) + 10;
	for (int a = 0; a * a <= c_squared; a++) {
		while (b >= 0 and a * a + b * b > c_squared)
			b--;
		if (a * a + b * b != c_squared)
			continue;
		res.emplace_back(a, b);
		res.emplace_back(a, -b);
		res.emplace_back(-a, b);
		res.emplace_back(-a, -b);
	}
	return res;
}

void solved(const vector<pt>& pos)
{

	int min_x = 1e9, min_y = 1e9;
	for (auto [x, y] : pos) {
		min_x = min(min_x, x);
		min_y = min(min_y, y);
	}
	cerr << min_x << ' ' << min_y << endl;
	for (auto [x, y] : pos)
		cout << x - min_x + 1 << ' ' << y - min_y + 1 << '\n';
	exit(0);
}

signed main()
{
	int n;
	cin >> n;
	vector<vi> d_squared(n, vi(n));
	for (int i = 0; i < n; i++)
		for (int j = 0; j < n; j++)
			cin >> d_squared[i][j];

	vector<vector<pt>> vectors(n);
	for (int i = 1; i < n; i++)
		vectors[i] = find_vectors(d_squared[0][i]);

	vector<pt> pos(n);

	const auto check = [&](int i, int j) {
		return len2(pos[i] - pos[j]) == d_squared[i][j];
	};

	if (n == 2 and not vectors[1].empty()) {
		pos[1] = vectors[1][0];
		solved(pos);
	}

	for (pt p1 : vectors[1]) {
		if (p1.x < 0 or p1.y < 0)
			continue;
		pos[1] = p1;
		for (pt p2 : vectors[2]) {
			pos[2] = p2;
			if (not check(1, 2))
				continue;
			for (int i = 3; i < n; i++) {
				for (pt pi : vectors[i]) {
					pos[i] = pi;
					if (check(1, i) and check(2, i))
						break;
				}
				if (not check(1, i) or not check(2, i))
					goto nope;
				for (int j = 0; j < i; j++)
					if (not check(j, i)) {
						cout << "impossible\n";
						exit(0);
					}
			}
			solved(pos);
		nope:;
		}
	}
	cout << "impossible\n";
}
