#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;
#define all(x) ::begin(x), ::end(x)
void _d(auto... x) { ((cerr << ' ' << x), ...) << endl; }
#define debug(x...) cerr << "["#x"]:", _d(x)

int main() {
    cin.tie(0)->sync_with_stdio(0);

    int n;
    cin >> n;
    vector<vector<ll>> d(n, vector<ll>(n));
    for (int i=0; i<n; i++) for (int j=0; j<n; j++) cin >> d[i][j];
    
    vector<vector<array<ll, 2>>> vec(n);
    for (int i=1; i<n; i++) {
        for (ll x=1; x*x<=d[0][i]; x++) {
            ll y = sqrtl(d[0][i] - x*x);
            if (x*x + y*y == d[0][i]) {
                vec[i].push_back({x, y});
                vec[i].push_back({y, x});
                vec[i].push_back({-x, y});
                vec[i].push_back({y, -x});
                vec[i].push_back({x, -y});
                vec[i].push_back({-y, x});
                vec[i].push_back({-x, -y});
                vec[i].push_back({-y, -x});
            }
        }
        sort(all(vec[i]));
        vec[i].erase(unique(all(vec[i])), vec[i].end());
    }

    vector<array<ll, 2>> ans(n);
    ans[0] = {(int)1e8, (int)1e8};

    auto dist = [&](int i, int j) {
        ll dx = ans[i][0] - ans[j][0];
        ll dy = ans[i][1] - ans[j][1];
        return dx*dx + dy*dy;
    };

    auto cross = [&](array<ll, 2> a, array<ll, 2> b) {
        return a[0] * b[1] - a[1] * b[0];
    };

    auto line = [&](int k) {
        return cross({ans[0][0] - ans[k][0], ans[0][1] - ans[k][1]}
                    ,{ans[1][0] - ans[k][0], ans[1][1] - ans[k][1]}) == 0;
    };

    auto gen = [&](auto& self, int i, int good) -> bool {
        if (i == n) {
            for (int j=0; j<n; j++) {
                for (int k=0; k<n; k++) {
                    if (d[j][k] != dist(j, k)) return false;
                }
            }
            return true;
        }

        int cnt = 0;
        for (auto [x, y] : vec[i]) {
            ans[i] = {ans[0][0] + x, ans[0][1] + y};

            if (dist(1, i) != d[1][i]) continue;
            if (dist(good, i) != d[good][i]) continue;
            if (!line(i)) good = i;
            cnt++;
            //if (i > 2) debug(good), assert(cnt <= 1);
            //if (good == i && good > 1) assert(cnt == 1);
            if (self(self, i+1, good)) return true;
        }
        return false;
    };
    
    if (gen(gen, 1, 1)) {
        for (auto [x, y] : ans) cout << x << ' ' << y << '\n';
    } else {
        cout << "impossible\n";
    }
}
