#include "bits/stdc++.h"
using namespace std;

const long long MAX_SQUARED_DIST = 1000000000LL;

const long long OFFSET = 500000000LL;

const int MAXN = 500;
int n;

int adj[500][500];

pair<long long, long long> sol[MAXN];

vector<pair<int, int>> consistent_with_fst_snd[MAXN];
vector<pair<int, int>> consistent_with_fst[MAXN];

long long int_root(long long n){
    double r = sqrt(n);
    long long res = round(r);
    if(abs(res - r) < 0.00001) return res;
    else return -1;
    /*
    Integer Safe (no necessary)
    long long lo = 0;
    long long hi = ceil(sqrt(n)) + 1;
    while(hi - lo > 1){
        long long mid = (hi + lo + 1)/2;
        if(mid * mid <= n) lo = mid;
        else hi = mid;
    }
    if(lo * lo == n) return lo;
    else return -1;
    */
}

void ensure(bool cond){
    if(!cond){
        cout << "impossible" << endl;
        exit(0);
    }
}

// This solution assumes the first 3

set<pair<long long, long long>> * find_deltas(int i, int j){
    long long sd = adj[i][j];
    auto res = new set<pair<long long, long long>>();
    long long limit = sd;
    for(long long dx = 0; dx*dx <= limit; dx++){
        long long dy = int_root(sd - dx*dx);
        if(dy < 0) continue;
        res->insert({dx, dy});
        res->insert({dx, -dy});
        res->insert({-dx, dy});
        res->insert({-dx, -dy});
    }
    return res;
}

void ensure_symmetry(){
    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            ensure(adj[i][j] == adj[j][i]);
        }
    }
}

bool is_consistent(int i, int j){
    long long mdx = sol[i].first - sol[j].first;
    long long mdy = sol[i].second - sol[j].second;
    return mdx*mdx + mdy*mdy == adj[i][j];
}

void reject(){
    cout << "impossible" << endl;
    exit(0);
}

void accept(){
    for(int i=0; i<n; i++){
        cout << sol[i].first + OFFSET << " " << sol[i].second + OFFSET << endl;
    }
    exit(0);
}

bool is_solution_consistent(){
    for(int i=0; i<n; i++){
        for(int j = 0; j<n; j++){
            if(!is_consistent(i, j)) return false;
        }
    }
    return true;
}

void accept_or_reject(){
    if(is_solution_consistent()) accept();
    else reject();
}



void place_rel(int i, int j, pair<int, int> delta){
    sol[j] = {sol[i].first + delta.first, sol[i].second + delta.second};
}

int main(){
    cin >> n;
    for(int i=0; i<n; i++){
        for(int j=0; j<n; j++){
            cin >> adj[i][j];
        }
    }
    ensure_symmetry();


    int fst = 0;
    // place 1 object in the middle
    sol[fst] = {0, 0};

    if(n == 1) accept();

    int snd = -1;
    for(int i=1; i<n; i++) {
        for(auto delta : *find_deltas(fst, i)){
            consistent_with_fst[i].push_back(delta);
        }
        if(consistent_with_fst[i].size() > 1) snd = i;
        ensure(consistent_with_fst[i].size() > 0);
    }

    if(snd < 0 || n == 2){
        for(int i=1; i<n; i++){
            place_rel(fst, i, consistent_with_fst[i][0]);
        }
        accept_or_reject();
    }

    for(auto delta_snd : consistent_with_fst[snd]){
        place_rel(fst, snd, delta_snd);

        int trd = -1;
        bool possible = true;
        for(int i=1;i<n; i++){
            if(i == snd) continue;
            for(auto delta_i: *find_deltas(fst, i)){
                place_rel(fst, i, delta_i);
                if(is_consistent(i, snd)) consistent_with_fst_snd[i].push_back(delta_i);
            }
            if(consistent_with_fst_snd[i].size() > 1) trd = i;
            if(consistent_with_fst_snd[i].size() == 0) possible = false;
        }

        if(!possible) continue;

        if(trd < 0){
            // We have a unique solution!
            for(int i=1;i<n; i++){
                if(i == snd) continue;
                place_rel(fst, i, consistent_with_fst_snd[i][0]);
            }
            accept_or_reject();
        }

        for(auto delta_trd : consistent_with_fst_snd[trd]){
            place_rel(fst, trd, delta_trd);

            possible = true;
            for(int i=1; i<n; i++){
                if(i == snd || i == trd) continue;
                bool placed = false;
                for(auto delta_i : consistent_with_fst_snd[i]){
                    place_rel(fst, i, delta_i);
                    if(is_consistent(trd, i)){
                        placed = true;
                        break;
                    }
                }
                if(!placed){
                    possible = false;
                    break;
                }
            }
            if(possible) accept_or_reject();
        }
    }
    reject();
    return 0;
}
