#!/usr/bin/env python3
from math import isqrt

n = int(input())
d = [list(map(int, input().split())) for _ in range(n)]

def vectors(r2):
  y = isqrt(r2)
  for x in range(y+1):
    while x*x + y*y > r2:
      y -= 1
    if x*x + y*y == r2:
      yield x, y
      yield x, -y
      yield -x, y
      yield -x, -y

m = 5 * 10**8
x, y = [m] * n, [m] * n
def rec(j):
  if j == n:
    for i in range(n):
      print(x[i], y[i])
    exit(0)
  for dx, dy in vectors(d[0][j]):
    x[j], y[j] = x[0] + dx, y[0] + dy
    if all((x[j]-x[i])**2 + (y[j]-y[i])**2 == d[i][j] for i in range(j)):
      rec(j+1)

rec(1)
print('impossible')
