
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.*;

public class jannik_buffered_reader {
  static class Pt {
    public long x, y;

    public Pt(long xx, long yy) {
      x = xx;
      y = yy;
    }
  }

  static long dot(Pt a, Pt b) {
    return a.x * b.x + a.y * b.y;
  }

  static long len2(Pt a, Pt b) {
    long x = a.x - b.x;
    long y = a.y - b.y;
    return x * x + y * y;
  }

  static Pt[] find_vectors(long d) {
    ArrayList<Pt> res = new ArrayList<>();
    long b = (long) Math.sqrt(d) + 10;
    for (long a = 0; a * a <= d; a++) {
      while (b >= 0 && a * a + b * b > d)
        b--;
      if (a * a + b * b != d)
        continue;
      res.add(new Pt(a, b));
      res.add(new Pt(a, -b));
      res.add(new Pt(-a, b));
      res.add(new Pt(-a, -b));
    }
    return (Pt[]) res.toArray(new Pt[res.size()]);
  }

  static long[][] d_squared;
  static Pt[] pos;

  static void solved() {
    long min_x = Long.MAX_VALUE, min_y = Long.MAX_VALUE;
    for (Pt p : pos) {
      min_x = Math.min(min_x, p.x);
      min_y = Math.min(min_y, p.y);
    }
    for (Pt p : pos)
      System.out.println((p.x - min_x + 1) + " " + (p.y - min_y + 1));
    System.exit(0);
  }

  static boolean check(int i, int j) {
    return len2(pos[i], pos[j]) == d_squared[i][j];
  }

  public static void main(String[] args) throws IOException {
    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
    String[] line = rd.readLine().split(" ");
    int n = Integer.parseInt(line[0]);
    d_squared = new long[n][n];
    for (int i = 0; i < n; i++) {
      line = rd.readLine().split(" ");
      for (int j = 0; j < n; j++)
        d_squared[i][j] = Long.parseLong(line[j]);
    }

    Pt[][] vectors = new Pt[n][];
    for (int i = 1; i < n; i++)
      vectors[i] = find_vectors(d_squared[0][i]);

    pos = new Pt[n];
    pos[0] = new Pt(0, 0);

    if (n == 2 && vectors[1].length > 0) {
      pos[1] = vectors[1][0];
      solved();
    }

    int f1 = 2;
    for (int j = 3; j < n; j++)
      for (Pt p1 : vectors[1]) {
        pos[1] = p1;
        for (Pt p2 : vectors[j]) {
          pos[j] = p2;
          if (dot(p1, new Pt(-p2.y, p2.x)) != 0 && check(1, j))
            f1 = j;
        }
      }

    for (Pt p1 : vectors[1]) {
      if (p1.x < 0 || p1.y < 0)
        continue;
      pos[1] = p1;
      p2loop: for (Pt p2 : vectors[f1]) {
        pos[f1] = p2;
        if (!check(1, f1))
          continue;
        for (int i = 2; i < n; i++) {
          if (i == f1)
            continue;
          for (Pt pi : vectors[i]) {
            pos[i] = pi;
            if (check(1, i) && check(f1, i))
              break;
          }
          if (pos[i] == null || !check(1, i) || !check(f1, i))
            continue p2loop;
          for (int j = 0; j < i; j++)
            if (!check(j, i)) {
              System.out.println("impossible");
              return;
            }
        }
        solved();
      }
    }
    System.out.println("impossible");
  }
}
