import qualified Data.ByteString.Char8 as B
import Data.Maybe
import Control.Monad
import Data.Foldable

int = fst . fromJust . B.readInt

data Pt = Pt {x :: !Int, y :: Int}

(Pt a b) ~ (Pt c d) = Pt (a - c) (b - d)
(Pt a b) # (Pt c d) = a * c + b * d

len2 :: Pt -> Pt -> Int
len2 a b = (a ~ b) # (a ~ b)

sameLine :: Pt -> Pt -> Bool
sameLine a (Pt x y) = (a # Pt y (-x)) == 0

findVectors :: Int -> [Pt]
findVectors csq
    = concatMap (\p -> [p, p{x = -x p}, p{y= -y p}, Pt (-x p) (-y p)])
    $ go ((+10) . ceiling . sqrt $ fromIntegral csq) 0
  where
    go b a
      | a^2 > csq                 = []
      | b >= 0 && a^2 + b^2 > csq = go (b - 1) a
      | a^2 + b^2 == csq          = Pt a b : go b (a + 1)
      | otherwise                 = go b (a + 1)

output :: [Pt] -> String
output ps = unlines [show (x - mx + 1) ++ " " ++ show (y - my + 1) | Pt x y <- ps]
  where
    mx = minimum $ x <$> ps
    my = minimum $ y <$> ps

main =
  B.getContents
    >>= putStr
      . maybe "impossible\n" output
      . solve
      . map (map int . B.words)
      . tail
      . B.lines

solve :: [[Int]] -> Maybe [Pt]
solve dist = find check $ listToMaybe $ catMaybes
  [ ([Pt 0 0, s] ++) <$> sequence
      [ listToMaybe [ p | p <- ps, len2 s p == ds, len2 t p == dt ]
      | (ps,ds,dt) <- drop 2 $ zip3 vecs (dist!!1) distt
      ]
  | s <- vecs!!1, x s >= 0, y s >= 0
  , t <- tvecs, len2 s t == distt!!1
  ]
  where
    (tvecs,distt) = fromMaybe ([Pt 0 0], head dist) $ listToMaybe
           [ (vs,distt)
           | (vs,ds,distt) <- drop 2 $ zip3 vecs (dist!!1) dist
           , or [ len2 s t == ds && not (sameLine s t) | t <- vs, s <- vecs!!1 ]
           ]
    vd = zip vecs (dist!!1)
    n = length dist
    vecs = findVectors <$> head dist
    check ps = and $ zipWith (==) (concat dist) (len2 <$> ps <*> ps)
