#include "validate.h"
#include <cassert>

using namespace std;

struct pt {
	Integer x = 0, y = 0;
};
pt operator-(const pt& lhs, const pt& rhs)
{
	return pt { lhs.x - rhs.x, lhs.y - rhs.y };
}
pt operator+(const pt& lhs, const pt& rhs)
{
	return pt { lhs.x + rhs.x, lhs.y + rhs.y };
}
Integer len2(const pt& x)
{
	return x.x * x.x + x.y * x.y;
}

constexpr Integer maxcoord = 1'000'000'000;
constexpr Integer maxdist = 1'000'000'000;
optional<vector<pt>> read_answer(InputStream& in, Integer n, OutputValidator::Verdict onFail)
{
	const string ans = in.string();
	if (ans == "impossible") {
		in.newline();
		in.eof();
		return nullopt;
	}

	Integer first;
	if (not details::parse(ans, first))
		OutputValidator::juryOut << "expected Integer or \"impossible\" but got \"" << ans << '\"' << onFail;
	if (first < 1 or first > maxcoord)
		OutputValidator::juryOut << "expected Integer between " << 1 << " and " << maxcoord << ", but got " << '\"' << first << '\"' << onFail;

	vector<pt> res(n);
	for (int i = 0; i < n; i++) {
		if (i == 0)
			res[i].x = first;
		else
			res[i].x = in.integer(1, maxcoord + 1);
		in.space();
		res[i].y = in.integer(1, maxcoord + 1);
		in.newline();
	}
	in.eof();
	return res;
}

void check(Integer n, const vector<vector<Integer>>& d, const vector<pt>& pos, Verdicts::Verdict v)
{
	for (Integer i = 0; i < n; i++)
		for (Integer j = 0; j < n; j++)
			if (len2(pos[i] - pos[j]) != d[i][j])
				ValidateBase::juryOut
					<< "squared distance between " << i + 1 << " and " << j + 1
					<< " should be " << d[i][j] << " but is " << len2(pos[i] - pos[j])
					<< v;
}

int main(int argc, char** argv)
{
	using namespace OutputValidator;
	init(argc, argv);

	const Integer n = testIn.integer(2, 500 + 1);
	testIn.newline();
	vector<vector<Integer>> d(n);
	for (int i = 0; i < n; i++) {
		d[i].resize(n);
		for (int j = 0; j < n; j++) {
			if (j)
				testIn.space();
			d[i][j] = testIn.integer(i == j ? 0 : 1, maxdist + 1);
		}
		testIn.newline();
	}
	testIn.eof();

	const auto jury = read_answer(juryAns, n, FAIL);
	if (jury)
		check(n, d, *jury, FAIL);
	const auto team = read_answer(teamAns, n, WA);
	if (team)
		check(n, d, *team, WA);
	if (team and not jury)
		juryOut << "Oh no! Team found solution but jury didn't!" << FAIL;
	if (jury and not team)
		juryOut << "Team found no solution, but jury has one" << WA;

	juryOut << "OK" << AC;
}
