#include "validate.h"
#include <cassert>
#include <string_view>

using namespace std;

int hamming_distance(string_view a, string_view b)
{
	assert(a.size() == b.size());
	int res = 0;
	for (size_t i = 0; i < a.size(); i++)
		res += a[i] != b[i];
	return res;
}

void check(string_view a, string_view b, string_view c, Verdicts::Verdict v)
{
	int dist = hamming_distance(a, b);
	int da = hamming_distance(a, c);
	int db = hamming_distance(b, c);
	if (da > (dist + 1) / 2)
		ValidateBase::juryOut << "distance to a is " << da << " but should be at most " << (dist + 1) / 2 << v;
	if (db > (dist + 1) / 2)
		ValidateBase::juryOut << "distance to b is " << db << " but should be at most " << (dist + 1) / 2 << v;
}

int main(int argc, char** argv)
{
	using namespace OutputValidator;
	init(argc, argv);

	const Integer n = testIn.integer();
	testIn.newline();
	const string a = testIn.string(regex("[a-z]+"), n, n + 1);
	testIn.newline();
	const string b = testIn.string(regex("[a-z]+"), n, n + 1);
	testIn.newline();
	testIn.eof();

	const string jury = juryAns.string(regex("[a-z]+"), 0, n + 1);
	juryAns.newline(), juryAns.eof();
	check(a, b, jury, FAIL);

	const string team = teamAns.string(regex("[a-z]+"), n, n + 1);
	teamAns.newline(), teamAns.eof();
	check(a, b, team, WA);

	juryOut << "OK" << AC;
}
