#include <iostream>
#include <vector>
#include <random>

using namespace std;

// This solution uses randomized plays to fuzz the output validator
int main() {
	int rounds, players;
	cin >> rounds >> players;

	if (rounds == 1) {
		cout << "Impossible" << endl;
		return 0;
	}

	time_t seed = time(0) / 60 / 10;  // align to 10 minutes for reproducibility
	cerr << "Seed: " << seed << endl;

	mt19937 rng;
	rng.seed(seed);

	vector<int> points(players);
	for (int i = 1; i < rounds; ++i) {
		vector<int> guessed(players);
		for(int k = 0; k < i; ++k) {
			++guessed[rng() % players];
		}
		
		for (int j = 0; j < players; ++j) {
			cout << guessed[j] << " " << guessed[j] << " ";
			points[j] += 20 + guessed[j] * 10;
		}
		cout << endl;
	}

	vector<int> guessed(players);
	for(int k = 0; k < rounds; ++k) {
		++guessed[rng() % players];
	}

	for (int j = 0; j < players; ++j) {
		cout << guessed[j] + points[j] / 10 << " " << guessed[j] << " ";
	}
	cout << endl;
}
