#include "validate.h"

int main(int argc, char **argv) {
	OutputValidator::init(argc, argv);
	using namespace OutputValidator;

	if (stringEqual(juryAns.string(), "impossible")) {
		teamAns.expectString("impossible");
		teamAns.newline();
		teamAns.eof();
		juryOut << "OK impossible" << AC;
	} else {
		Integer n = testIn.integer();
		Integer k = testIn.integer();
		std::vector<Integer> points(k);
		for (Integer i = 1; i <= n; i++) {
			auto line = teamAns.integers(2*k, 0, 1'000'000 + 1);
			teamAns.newline();
			Integer made = 0;
			for (Integer j = 0; j < k; j++) {
				made += line[2*j+1];
				Integer diff = std::abs(line[2*j] - line[2*j+1]);
				if (diff == 0) {
					points[j] += 20 + 10 * line[2*j];
				} else {
					points[j] -= 10 * diff;
				}
			}
			if (made != i) {
				juryOut << "wrong answer: " << made << " tricks were taken in round " << i << "!" << WA;
			}
		}
		for (Integer i = 0; i < k; i++) {
			if (points[i] != 0) {
				juryOut << "wrong answer: player " << i+1 << " has " << points[i] << " points!" << WA;
			}
		}
		teamAns.eof();
		juryOut << "OK possible" << AC;
	}
}
