#include "validation.h"

const int MAX_QUERIES = 5000;

int main(int argc, char *argv[]) {
    std::ifstream in(argv[1]);
    OutputValidator v(argc, argv);

    int radius;
    in >> radius;

    int px = 0, py = 0;
    for (int query = 0; query <= MAX_QUERIES; query++) {
        std::string type = v.read_string("type", 1, 1, "?!");
        if (type[0] == '!') {
            int guess = v.read_integer("guess", 0, 1e9);
            v.newline();
            v.check(guess == radius, "Wrong answer: current radius is ",
                    radius, ", but received guess ", guess);
            break;
        }

        if (query == MAX_QUERIES) {
            v.WA("Wrong answer: reached the query limit of ", MAX_QUERIES);
        }

        // Before each '?' query, increase radius by 1
        radius++;

        int x = v.read_integer("x", -1e9, 1e9);
        v.space();
        int y = v.read_integer("y", -1e9, 1e9);
        v.newline();

        int distance_to_previous = std::abs(x-px) + std::abs(y-py);

        v.check(distance_to_previous <= 1000, "Wrong answer: query location (", x, ", ",
                y, ") has distance ", distance_to_previous, " to previous location");

        int distance_to_center = std::abs(x) + std::abs(y);
        std::string answer = distance_to_center <= radius ? "in" : "out";
        std::cout << answer << std::endl;

        // Update position
        px = x, py = y;
    }
}
