#include<bits/stdc++.h>
using namespace std;

const int MAXN = 5000;
vector<int> adj[MAXN];
vector<int> backadj[MAXN];
bool vis[MAXN];

int num_reachable[MAXN];
int num_back_reachable[MAXN];

bool valuable[MAXN];
bool cheap[MAXN];

vector<int> ordered_elements;
int final_output[MAXN];


void fill_valuable(int u){
    if(vis[u]) return;
    vis[u] = true;
    valuable[u] = true;
    for(int v: backadj[u]){
        fill_valuable(v);
    }
}

void count_back_reachable(int u, int start){
    if(vis[u]) return;
    vis[u] = true;
    num_back_reachable[start] = u == start ? 0 : num_back_reachable[start] + 1;
    for(int v: backadj[u]) count_back_reachable(v, start);
}

void count_reachable(int u, int start){
    if(vis[u]) return;
    vis[u] = true;
    num_reachable[start] = u == start ? 0 : num_reachable[start] + 1;
    for(int v: adj[u]) count_reachable(v, start);
}

int output_remaining_cheap(int u, int remaining, int l){
    if(remaining <= 0) return 0;
    if(vis[u]) return remaining;
    vis[u] = true;
    for(int v: adj[u]){
        remaining = output_remaining_cheap(v, remaining, l);
    }
    if(remaining > 0 && !valuable[u] && !cheap[u] && u != l){
        remaining--;
        ordered_elements.push_back(u);
        cheap[u] = true;
    }
    return remaining;
}
void output_remaining_valuable(int u){
    if(vis[u]) return;
    vis[u] = true;

    if(cheap[u]) return;

    // first, output all branches that do not lead to k
    for(int v: adj[u]) if(!valuable[v]) output_remaining_valuable(v);
    // then, output all branches that lead to k
    for(int v: adj[u]) if(valuable[v]) output_remaining_valuable(v);

    
    ordered_elements.push_back(u);
    
}


void output_cheap(int u){
    if(vis[u]) return;
    vis[u] = true;
    for(int v: adj[u]) output_cheap(v);
    ordered_elements.push_back(u);
    cheap[u] = true;
}

int n, m, k;
int main(){
    cin >> n >> m >> k;

    for(int i=0; i<m; i++){
        int x, y;
        cin >> x >> y;
        adj[x].push_back(y); // x can be traded for y
        backadj[y].push_back(x);
    }

    if(n < k){
        cout << "impossible" << endl;
        return 0;
    }

    for(int i=1; i<=n; i++){
        memset(vis, false, sizeof(vis));
        count_reachable(i, i);
        memset(vis, false, sizeof(vis));
        count_back_reachable(i, i);
    }

    int valid_l = -1;
    int valid_p = -1;
    for(int l=1; l<=n; l++){
        if(adj[l].size() > 0) continue;

        int larger_than_l = num_back_reachable[l];
        if(larger_than_l > n - k) continue;
        for(int p : backadj[l]){
            int smaller_than_l = num_reachable[p] - 1;
            if(smaller_than_l >= k) continue;
            valid_l = l;
            valid_p = p;
        }
    }

    if(valid_l < 0) cout << "impossible" << endl;
    else {
        //cout << "possible" << endl;

        memset(cheap, false, sizeof(cheap));
        memset(valuable, false, sizeof(valuable));

        // output all vertices reachable from valid_p except for valid_l and mark them as cheap
        memset(vis, false, sizeof(vis));
        for(int v: adj[valid_p]) if(v != valid_l) output_cheap(v);


        // determine the valuable vertices and mark them
        memset(vis, false, sizeof(vis));
        fill_valuable(valid_p);
        
        // Fill up remaining cheap vertices with unmarked vertices (mark l as cheap to prevent it being used)
        cheap[valid_l] = true;
        int remaining_cheap = k - 1 - (num_reachable[valid_p] - 1);
        memset(vis, false, sizeof(vis));
        output_remaining_cheap(1, remaining_cheap, valid_l);

        ordered_elements.push_back(valid_l);
        
        // Now finish with the valuable vertices
        memset(vis, false, sizeof(vis));
        output_remaining_valuable(1);

        // Compute final output
        for(int i = 0; i<ordered_elements.size(); i++){
            int elem = ordered_elements[i];
            final_output[elem] = i + 1; // the i-th element is the i-th cheapest
        }

        for(int i=1; i<=n; i++) cout << final_output[i] << " ";



        cout << endl;
    }
}