#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;
#define all(x) ::begin(x), ::end(x)
void _d(auto... x) { ((cerr << ' ' << x), ...) << endl; }
#define debug(x...) cerr << "["#x"]:", _d(x)

int main() {
    cin.tie(0)->sync_with_stdio(0);

    int n, m, k;
    cin >> n >> m >> k;
    k--;
    vector<vector<int>> g(n), g_rev(n);
    vector<int> deg(n);
    for (int i=0; i<m; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        g[u].push_back(v);
        g_rev[v].push_back(u);
        deg[u]++;
    }
    auto deg2 = deg;

    constexpr int N = 3005;
    using bs = bitset<N>;
    vector<bs> reachable(n);
    auto dfs = [&](auto& self, int u) -> void {
        if (reachable[u][u]) return;
        reachable[u][u] = true;

        for (int v : g[u]) {
            self(self, v);
            reachable[u] |= reachable[v];
        }
        sort(all(g[u]), [&](int x, int y) {
            return reachable[x].count() < reachable[y].count();
        });
    };
    dfs(dfs, 0);

    auto attempt = [&](int u, int v) -> void {
        deg = deg2;
        vector<int> ans(n, -1);
        int counter1 = 0;
        int counter2 = reachable[u].count() - 2;
        vector<int> st;
        for (int i=0; i<n; i++) if (deg[i] == 0) st.push_back(i);

        ans[v] = k;
        int orig = u;
        u = v;
        while (true) {
            while (!st.empty()) {
                int w = st.back();
                if (ssize(st) > 1 && w == u) {
                    swap(st[0], st.back());
                    continue;
                }
                st.pop_back();

                for (int w2 : g_rev[w]) if (--deg[w2] == 0) st.push_back(w2);

                counter2 += counter2 == k;
                if (w == v);
                else if (reachable[orig][w] && w != u) ans[w] = counter1++;
                else ans[w] = counter2++;

                if (ans[w] < k && reachable[w][v]) return;
                if (w == u) break;
            }
            if (u == 0) break;
            if (u == v) u = orig;
            else u = g_rev[u][0];
        }

        for (int e : ans) cout << e+1 << ' ';
        cout << '\n';
        exit(0);
    };

    for (int u=0; u<n; u++) {
        if ((int)reachable[u].count() > k + 2) continue;

        for (int v : g[u]) {
            bool ok = g[v].empty();
            for (int v2 : g[u]) if (v2 != v && reachable[v2][v]) ok = false;

            if (ok) attempt(u, v);
        }
    }
    cout << "impossible\n";
}
