#include <bits/stdc++.h>
using namespace std;

using bs = bitset<3001>;

int n;

vector<int> reachability(vector<vector<int>> g){
	vector<bs> dp(n);
	vector<bool> vis(n);
	auto dfs = [&](auto&& self, int u) -> void {
		vis[u] = true;
		dp[u][u] = 1;
		for(int v : g[u]){
			if(!vis[v]) self(self, v);
			dp[u] |= dp[v];
		}
	};
	vector<int> numReach(n);
	for(int i = 0; i < n; i++){
		if(!vis[i]) dfs(dfs, i);
		numReach[i] = dp[i].count();
	}
	return numReach;
}

int main(){
	int m, k;
	cin >> n >> m >> k;
	vector<vector<int>> g(n), grev(n);
	vector<int> out(n);
	for(int i = 0; i < m; i++){
		int u, v;
		cin >> u >> v;
		u--, v--;
		g[u].push_back(v);
		grev[v].push_back(u);
		out[u]++;
	}
	vector<bool> mark(n);
	auto dfsMark = [&](auto&& self, vector<vector<int>>& gr, int u) -> void {
		mark[u] = true;
		for(int v : gr[u]){
			if(!mark[v]) self(self, gr, v);
		}
	};
	vector<int> reaches = reachability(g);
	vector<int> reachedBy = reachability(grev);
	for(int u = 0; u < n; u++){
		for(int v : g[u]){
			if(!g[v].empty()) continue;
			if(k >= reaches[u]-1 && n-k >= reachedBy[v]-1){
				// reconstruct answer
				vector<int> ans(n);
				int cur = 1;
				dfsMark(dfsMark, g, u);
				mark[v] = 0;
				mark[u] = 0;
				vector<int> st;
				for(int x = 0; x < n; x++){
					if(mark[x] && out[x] == 0) st.push_back(x);
				}
				while(!st.empty()){
					int x = st.back();
					st.pop_back();
					ans[x] = cur++;
					for(int y : grev[x]){
						if(--out[y] == 0 && mark[y]) st.push_back(y);
					}
				}
				mark.assign(n, false);
				dfsMark(dfsMark, grev, u);
				mark[v] = true;
				for(int x = 0; x < n; x++){
					if(ans[x] == 0 && out[x] == 0 && !mark[x]) st.push_back(x);
				}
				while(!st.empty() || cur <= k){
					if(cur == k) st.push_back(v);
					assert(!st.empty());
					int x = st.back();
					st.pop_back();
					ans[x] = cur++;
					for(int y : grev[x]){
						if(--out[y] == 0 && !mark[y]) st.push_back(y);
					}
				}
				st.push_back(u);
				while(!st.empty()){
					int x = st.back();
					st.pop_back();
					ans[x] = cur++;
					for(int y : grev[x]){
						if(--out[y] == 0) st.push_back(y);
					}
				}
				for(int ind = 0; ind < n; ind++){
					cout << ans[ind] << " \n"[ind==n-1];
				}
				return 0;
			}
		}
	}
	cout << "impossible\n";
}