#include<bits/stdc++.h>
using namespace std;

const int MAXN = 5000;
int n, m, k;

vector<int> adj[MAXN];
vector<int> backadj[MAXN];
bool vis[MAXN];

vector<int> top_sorted;
int topsort_rank[MAXN];

int num_cheap = 0;
int num_reachable[MAXN];
int num_back_reachable[MAXN];

const int VALUABLE = 3, MEDIUM = 2, CHEAP = 1, UNMARKED = 0, L = -1;

int status[MAXN]; // marks whether the item is more valuable than the final item
bool cheap[MAXN]; // marks whether the item is less valuable i.e. one of the k-1 chepest items

int l, p;

vector<int> ordered_elements;
int final_output[MAXN];
vector<int> feasible_ps;

void topsort(int u){
    if(vis[u]) return;
    vis[u] = true;

    for(int v: adj[u]) topsort(v);
    top_sorted.push_back(u);
}

void count_back_reachable(int u, int start){
    if(vis[u]) return;
    vis[u] = true;
    num_back_reachable[start] = u == start ? 0 : num_back_reachable[start] + 1;
    for(int v: backadj[u]) count_back_reachable(v, start);
}

void count_reachable(int u, int start){
    if(vis[u]) return;
    vis[u] = true;
    num_reachable[start] = u == start ? 0 : num_reachable[start] + 1;
    for(int v: adj[u]) count_reachable(v, start);
}

void mark(int u, int s){
    status[u] = s;
    if(s == CHEAP) num_cheap++;
}

void mark_cheap(int u){
    if(vis[u]) return;
    vis[u] = true;
    for(int v: adj[u]) mark_cheap(v);
    mark(u, CHEAP);
}

void mark_valuable(int u){
    if(vis[u]) return;
    vis[u] = true;
    mark(u, VALUABLE);
    for(int v: backadj[u]) mark_valuable(v);
}

void mark_medium(int u){
    if(vis[u]) return;
    vis[u] = true;
    if(status[u] == UNMARKED) mark(u, MEDIUM);
    for(int v: backadj[u]) mark_medium(v);
}

void mark_remaining(int u){
    if(vis[u]) return;
    vis[u] = true;
    for(int v: adj[u]) mark_remaining(v);
    if(status[u] == UNMARKED) mark(u, num_cheap < k-1 ? CHEAP : MEDIUM);
}


void order(int u, int s){
    if(vis[u]) return;
    vis[u] = true;
    for(int v: adj[u]) order(v, s);
    if(status[u] == s) ordered_elements.push_back(u);
}


bool find_l_p(){
    for(int lc=1; lc<=n; lc++){
        if(adj[lc].size() > 0) continue;
        feasible_ps.clear(); // set of ps which satisfy the condition
        memset(vis, 0, sizeof(vis)); // pfusch

        int larger_than_l = num_back_reachable[lc];
        if(larger_than_l > n - k) continue;
        for(int pc : backadj[lc]){
            int smaller_than_l = num_reachable[pc] - 1;
            if(smaller_than_l >= k) continue;
            feasible_ps.push_back(pc);
            vis[pc] = true;
        }
        if(feasible_ps.size() == 0) continue;

        // For our construction, p must be topologically maximal
        int maxi = -1;
        int argmax = -1;
        for(int pc : feasible_ps){
            if(topsort_rank[pc] > maxi){
                maxi = topsort_rank[pc];
                argmax = pc;
            }
        }
        p = argmax;
        l = lc;
        return true;
    }
    return false;
}

void output(){
    // Compute final output
    for(int i = 0; i<ordered_elements.size(); i++){
        int elem = ordered_elements[i];
        final_output[elem] = i + 1; // the i-th element is the i-th cheapest
    }
    for(int i=1; i<=n; i++) cout << final_output[i] << " ";
    cout << endl;
}

int main(){
    cin >> n >> m >> k;

    for(int i=0; i<m; i++){
        int x, y;
        cin >> x >> y;
        adj[x].push_back(y); // x can be traded for y
        backadj[y].push_back(x);
    }

    topsort(1);
    reverse(top_sorted.begin(), top_sorted.end());
    for(int r=0; r<n; r++) topsort_rank[top_sorted[r]] = r;


    if(n < k){
        cout << "impossible" << endl;
        return 1;
    }

    for(int i=1; i<=n; i++){
        memset(vis, false, sizeof(vis));
        count_reachable(i, i);
        memset(vis, false, sizeof(vis));
        count_back_reachable(i, i);
    }

    if(!find_l_p()) cout << "impossible" << endl;
    else {
        memset(status, UNMARKED, sizeof(status));

        // Vertices reachable from p have to be cheap
        memset(vis, false, sizeof(vis));
        for(int v: adj[p]) if(v != l) mark_cheap(v);


        // Vertices which reach p have to be valuable
        memset(vis, false, sizeof(vis));
        mark_valuable(p);

        mark(l, L);

        // Vertices which reach l haveto be medium
        memset(vis, false, sizeof(vis));
        for(int u: backadj[l]) mark_medium(u);
        
        // Fill up remaining cheap vertices with unmarked vertices
        memset(vis, false, sizeof(vis));
        mark_remaining(1);

        for(int s : {CHEAP, L, MEDIUM, VALUABLE}){
            memset(vis, false, sizeof(vis));
            order(1, s);
        }

        output();
    }
}