#include <iostream>
#include <vector>
#include <queue>
#include <numeric>
#include <assert.h>
using namespace std;

int main() {
    int n, m, k;
    cin >> n >> m >> k;
    vector<vector<int>> g(n), g_rev(n);
    vector<int> out(n);
    for (int i = 0; i < m; i++) {
        int a, b;
        cin >> a >> b;
        a--; b--;
        g[a].push_back(b);
        g_rev[b].push_back(a);
        out[a]++;
    }

    auto dfs = [&](auto &&self, vector<vector<bool>> &reach, vector<vector<int>> &g, int u) -> void {
        assert (!reach[u][u]);
        reach[u][u] = true;

        for (int v: g[u]) {
            if (!reach[v][v]) self(self, reach, g, v);
            for (int i = 0; i < n; i++) reach[u][i] = reach[u][i] || reach[v][i];
        }
    };
    vector<vector<bool>> can_reach(n, vector<bool>(n)), is_reached_by(n, vector<bool>(n));
    vector<int> num_reach(n), num_is_reached(n);
    for (int u = 0; u < n; u++) {
        if (!can_reach[u][u]) dfs(dfs, can_reach, g, u);
        if (!is_reached_by[u][u]) dfs(dfs, is_reached_by, g_rev, u);
        num_reach[u] = accumulate(can_reach[u].begin(), can_reach[u].end(), 0);
        num_is_reached[u] = accumulate(is_reached_by[u].begin(), is_reached_by[u].end(), 0);
    }
    assert (num_reach[0] == n);

    for (int v = 0; v < n; v++) if (num_is_reached[v] <= n - k + 1 && out[v] == 0) {
        for (int u: g_rev[v]) if (num_reach[u] <= k + 1) {
            // cout << "possible\n";
            vector<int> res(n, -1);

            res[v] = k;
            queue<int> q;
            for (int x = 0; x < n; x++) if (can_reach[u][x] && res[x] == -1 && out[x] == 0) q.push(x);
            int t = 1;
            while (!q.empty()) {
                int x = q.front();
                q.pop();
                assert (res[x] == -1);
                res[x] = t++;
                for (int y: g_rev[x]) if (--out[y] == 0 && can_reach[u][y]) q.push(y);
            }

            for (int x = 0; x < n; x++) if (!can_reach[x][v] && res[x] == -1 && out[x] == 0) q.push(x);
            while (!q.empty() && t != k) {
                int x = q.front();
                q.pop();
                assert (res[x] == -1);
                res[x] = t++;
                for (int y: g_rev[x]) if (--out[y] == 0 && !can_reach[y][v]) q.push(y);
            }
            queue<int>().swap(q);

            for (int x: g_rev[v]) out[x]--;

            for (int x = 0; x < n; x++) if (!can_reach[x][u] && res[x] == -1 && out[x] == 0) q.push(x);
            while (!q.empty()) {
                int x = q.front();
                q.pop();
                assert (res[x] == -1);
                res[x] = ++t;
                for (int y: g_rev[x]) if (--out[y] == 0 && !can_reach[y][u]) q.push(y);
            }
            for (int x = 0; x < n; x++) if (res[x] == -1 && out[x] == 0) q.push(x);
            while (!q.empty()) {
                int x = q.front();
                q.pop();
                assert (res[x] == -1);
                res[x] = ++t;
                for (int y: g_rev[x]) if (--out[y] == 0) q.push(y);
            }
            //assert (t == n);
            
            for (int i = 0; i < n; i++) cout << res[i] << " \n"[i + 1 == n];
            exit(0);
        }
    }
    cout << "impossible\n";
}
