import java.util.*;

class Yidi {
    static int n, m, k;
    static boolean[][] reachable;
    static ArrayList<Integer>[] g, g_rev;
    static int[] deg2;

	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);

        n = in.nextInt();
        m = in.nextInt();
        k = in.nextInt();
        k--;

        reachable = new boolean[n][n];
        g = new ArrayList[n];
        g_rev = new ArrayList[n];
        deg2 = new int[n];
        for (int i=0; i<n; i++) {
            g[i] = new ArrayList<>();
            g_rev[i] = new ArrayList<>();
        }

        for (int i=0; i<m; i++) {
            int u = in.nextInt();
            int v = in.nextInt();
            u--; v--;
            g[u].add(v);
            g_rev[v].add(u);
            deg2[u]++;
        }

        dfs(0);

        for (int u=0; u<n; u++) {
            if (sum(u) > k + 2) continue;

            for (int v : g[u]) {
                boolean ok = g[v].isEmpty();
                for (int v2 : g[u]) if (v2 != v && reachable[v2][v]) ok = false;
                if (ok) attempt(u, v);
            }
        }

        System.out.println("impossible");
	}

    public static int sum(int u) {
        int ans = 0;
        for (int i=0; i<n; i++) ans += reachable[u][i] ? 1 : 0;
        return ans;
    }

    public static void dfs(int u) {
        if (reachable[u][u]) return;
        reachable[u][u] = true;

        for (int v : g[u]) {
            dfs(v);
            for (int i=0; i<n; i++) reachable[u][i] |= reachable[v][i];
        }
        g[u].sort((x, y) -> {
            return sum(x) - sum(y);
        });
    }

    public static void attempt(int u, int v) {
        int[] deg = deg2.clone();
        int[] ans = new int[n];
        int counter1 = 0;
        int counter2 = sum(u) - 2;
        ArrayList<Integer> st = new ArrayList<>();
        for (int i=0; i<n; i++) {
            if (deg[i] == 0) st.add(i);
        }

        ans[v] = k;
        int orig = u;
        u = v;
        while (true) {
            while (!st.isEmpty()) {
                int w = st.get(st.size() - 1);
                if (st.size() > 1 && w == u) {
                    st.set(0, st.set(st.size()-1, st.get(0)));
                    continue;
                }
                st.remove(st.size() - 1);

                for (int w2 : g_rev[w]) {
                    if (--deg[w2] == 0) st.add(w2);
                }

                counter2 += counter2 == k ? 1 : 0;
                if (w == v);
                else if (reachable[orig][w] && w != u) ans[w] = counter1++;
                else ans[w] = counter2++;

                if (ans[w] < k && reachable[w][v]) return;
                if (w == u) break;
            }
            if (u == 0) break;
            if (u == v) u = orig;
            else u = g_rev[u].get(0);
        }

        for (int e : ans) System.out.print((e+1) + " ");
        System.out.println();
        System.exit(0);
    }
}
