#include "validate.h"
using namespace std;
using namespace OutputValidator;

Integer n, m, k;
vector<vector<Integer>> g;

bool readAndCheck(InputStream &in, string_view who, Verdict onFail) {
	string firstToken = in.string();
	if(firstToken == "impossible"){
		in.newline();
		in.eof();
		return false;
	}
	if(firstToken != to_string(n)){
		juryOut << "object with id 1 didn't get value n for " << who << "." << onFail;
	}
	vector<Integer> values(n);
	values[0] = n;
	vector<bool> used(n+1);
	used[n] = true;
	for(Integer i = 1; i < n; i++){
		in.space();
		values[i] = in.integer(1, n);
		if(used[values[i]]){
			juryOut << "value " << values[i] << " is assigned to multiple objects for " << who << "." << onFail;
		}
		used[values[i]] = true;
	}
	in.newline();
	in.eof();
	for(Integer u = 0; u < n; u++){
		for(Integer v : g[u]){
			if(values[u] < values[v]){
				juryOut << "the edge " << u+1 << " " << v+1 << " contradicts the assigned values " << values[u] << " " << values[v] << " for " << who << "." << onFail;
			}
		}
	}
	Integer cur = 0;
	while(!g[cur].empty()){
		Integer best = g[cur][0];
		for(Integer v : g[cur]){
			if(values[v] > values[best]) best = v;
		}
		cur = best;
	}
	if(values[cur] != k){
		juryOut << "the greedy path ends at the value " << values[cur] << " but it should be " << k << " for " << who << "." << onFail;
	}
	return true;
}

int main(int argc, char *argv[]) {
	OutputValidator::init(argc, argv);

	n = testIn.integer();
	m = testIn.integer();
	k = testIn.integer();

	g.resize(n);
	for(Integer i = 0; i < m; i++){
		Integer u = testIn.integer();
		Integer v = testIn.integer();
		u--, v--;
		g[u].push_back(v);
	}


	bool juryRes = readAndCheck(juryAns, "jury", FAIL);
	bool teamRes = readAndCheck(teamAns, "team", WA);

	if (teamRes && !juryRes) {
		juryOut << "Team found a solution, but jury did not!" << FAIL;
	}
	if (juryRes && !teamRes) {
		juryOut << "Jury found a solution, but team did not!" << WA;
	}
	juryOut << AC;
}
