#include "validate.h"
using namespace std;

constexpr Integer MAXN = 3000;
constexpr Integer MAXM = 9000;

int main(int argc, char **argv) {
	InputValidator::init(argc, argv);
	using namespace InputValidator;

	Integer n = testIn.integer(2, MAXN + 1);
	testIn.space();
	Integer m = testIn.integer(1, MAXM + 1);
	testIn.space();
	Integer k = testIn.integer(1, n+1);
	testIn.newline();
	vector<vector<Integer>> g(n);
	set<pair<int, int>> edges;
	for(Integer i = 0; i < m; i++){
		Integer u = testIn.integer();
		testIn.space();
		Integer v = testIn.integer();
		testIn.newline();
		if(u == v) juryOut << "self-edge" << u << " " << v << WA;
		if(edges.contains({u, v})) juryOut << "duplicate edge" << u << " " << v << WA;
		edges.emplace(u, v);
		u--, v--;
		g[u].push_back(v);
	}
	vector<int> state(n);
	bool cycle = false;
	auto dfs = [&](auto&& self, Integer u) -> void {
		state[u] = 1;
		for(Integer v : g[u]){
			if(state[v] == 0){
				self(self, v);
			}
			else if(state[v] == 1){
				cycle = true;
			}
		}
		state[u] = 2;
	};
	dfs(dfs, 0);
	if(cycle) juryOut << "cycle" << WA;
	for(Integer i = 0; i < n; i++){
		if(state[i] == 0) juryOut << "vertex " << i+1 << " is not reachable from 1" << WA;
	}

    testIn.eof();
	juryOut << "OK!" << AC;
}
