#include <bits/stdc++.h>
using namespace std;

/**
 * Choose the smallest dwarf
 * Fill up with n-1 worst dwarfs
 * Repeat
 */

struct Elem
{
    int height;
    int mining;
    int index;
    Elem(int h, int m, int i) : height(h), mining(m), index(i) {}
};

bool compare_mining(const Elem * a, const Elem * b){
    if(a->mining == b->mining) return a->index < b->index;
    return a->mining < b->mining;
}
bool compare_height(const Elem * a, const Elem * b){
    return a->height < b->height;
}
set<Elem *, decltype(&compare_mining)> sorted_by_mining(&compare_mining);
set<Elem *, decltype(&compare_height)> sorted_by_height(&compare_height);

// n*k log(n*k)
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    for (int a = 0; a < n * k; a++){
        Elem * e = new Elem(0, 0, a);
        cin >> e->height >> e->mining;
        sorted_by_height.insert(e);
        sorted_by_mining.insert(e);
    }

    long long total_mining_score = 0;

    for(int i=0; i<k; i++){
        Elem * smallest = *sorted_by_height.begin();
        total_mining_score += smallest->mining;
        sorted_by_height.erase(smallest);
        sorted_by_mining.erase(smallest);
        cout << smallest->index + 1 << " ";
        for(int j=0; j<n-1; j++){
            Elem * worst = *sorted_by_mining.begin();
            sorted_by_mining.erase(worst);
            sorted_by_height.erase(worst);
        }
    }
    cout << total_mining_score << endl;
}