#include <bits/stdc++.h>
using namespace std;


// This solution also computes an optimal partitioning by greedily filling up the groups once the smallest dwarf for each day has been selected

struct Elem
{
    int height;
    int mining;
    int index;
    Elem(int h, int m, int i) : height(h), mining(m), index(i) {}
};
vector<Elem> sorted;
vector<int> solution[100000];
priority_queue<Elem *> pool;

bool compare_mining(const Elem *a, const Elem *b){
    return a->mining < b->mining;
}
bool compare_height(Elem &a, Elem &b){
    return a.height < b.height;
}

// n*k log(n*k)
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    for (int a = 0; a < n * k; a++){
        sorted.push_back(Elem(0, 0, a));
        cin >> sorted[a].height >> sorted[a].mining;
    }
    sort(sorted.begin(), sorted.end(), compare_height);

    int total_mining_score = sorted[0].mining;
    std::priority_queue<Elem *, std::vector<Elem *>, std::function<bool(Elem *, Elem *)>> pool(compare_mining);
    for (int i = 0; i < k - 1; i++){
        for (int j = 0; j < n; j++) pool.push(&sorted[i * n + 1 + j]);
        total_mining_score += pool.top()->mining;
        pool.pop();
    }

    cout << total_mining_score << "\n";
    return 0;
}