{-# LANGUAGE BangPatterns #-}
import Data.Bifunctor
import qualified Data.ByteString.Char8 as B
import qualified Data.IntMap.Strict as M
import qualified Data.IntSet as S
import Data.List
import Data.Maybe

main = B.getContents >>= print . solve . map (map (fst . fromJust . B.readInt) . B.words) . B.lines

insertAll = foldl (flip S.insert)

step (!acc, pool) g = first (+ acc) $ S.deleteFindMax $ insertAll pool g

solve ([n, k] : a') = fst $ foldl step (f, S.empty) $ take (k - 1) $ unfoldr (Just . splitAt n) a
  where
    (f : a) = M.elems $ M.fromList [(h, m) | [h, m] <- a'] -- correct since heights are distinct
