#include<bits/stdc++.h>
using namespace std;

#define height first
#define mining second

long long n, k;
pair<int, int> sorted[300000];

vector<pair<int, int>> group;
vector<pair<int, int>> group_wo_smallest;

const long long oo = 1000000000LL * 300000LL;

long long dp_prev[300000];
long long dp_cur[300000];
long long partials[300000];
long long partials_wo_smallest[300000];
long long prev_maxd;

/**
 * Nobody is going to come up with this without having figured out the proper solution....
 * O(k*n*n)
 * 
 * Sort the dwarfs by ascending height
 * Consider the k continuous blocks of size k
 * dp[j][d]: Maximum total contribution of all blocks up to block j, given that d dwarfs from these blocks will be hired on day j+1, j+2, ... 
 */

long long get_prev(int d){
    if(d >= 0 && d <= prev_maxd) return dp_prev[d]; 
    return -oo;
}

int main(){
    cin >> n >> k;
    long long maxnk = max(n, k);

    for (long long a = 0; a < n * k; a++) {
        cin >> sorted[a].height >> sorted[a].mining;
    }

    sort(sorted, sorted + n*k);

    dp_prev[0] = 0;
    prev_maxd = 0;

    for(long long j=0; j<k; j++){
        group.clear();
        group_wo_smallest.clear();
        for(int i=0; i<n; i++) group.push_back(sorted[j*n + i]);
        sort(group.begin(), group.end(), [] (const auto& lhs, const auto& rhs) {
            return lhs.mining > rhs.mining;
        });

        // the j-th block of dwarves, sorted by mining score in descending order
        int min_height = sorted[j*n].height;
        for(auto & dwarf : group) if(dwarf.height > min_height) group_wo_smallest.push_back(dwarf);
        
        
        partials[0] = 0;
        for(int i=0; i<n; i++) partials[i+1] = partials[i] + group[i].mining;
        partials_wo_smallest[0] = 0;
        for(int i=0; i<n-1; i++) partials_wo_smallest[i+1] = partials_wo_smallest[i] + group_wo_smallest[i].mining;

        for(auto & dwarf : group_wo_smallest) assert(dwarf.height > min_height);
        assert(group_wo_smallest.size() == n- 1);
        assert(group.size() == n);

        long long maxd = min((n-1)*(j+1), k - 1 - j);

        for(long long d=0; d<= maxd; d++){
            dp_cur[d] = -oo;
            // hire the smallest dwarf as leader of group j
            for(long long give = 0; give <= min(d, n-1); give++){
                dp_cur[d] = max(dp_cur[d], partials_wo_smallest[give] + sorted[j*n].mining + get_prev(d - give));
            }

            // defer choosing a leader for group j
            dp_cur[d] = max(dp_cur[d], get_prev(d + 1));

            for(long long give = 0; give <= min(d, n); give++){
                dp_cur[d] = max(dp_cur[d], partials[give] + get_prev(d - give + 1));
            }
        }

        for(int d=0; d <= maxd; d++) dp_prev[d] = dp_cur[d];
        prev_maxd = maxd;

    }
    cout << dp_cur[0] << endl;
}