#include <bits/stdc++.h>
using namespace std;

struct Elem
{
    int height;
    int mining;
    int index;
    bool selected;
    Elem(int h, int m, int i) : height(h), mining(m), index(i), selected(false) {}
};
vector<Elem> sorted;
vector<int> solution[100000];
priority_queue<Elem *> pool;

bool compare_mining(const Elem *a, const Elem *b){
    return a->mining < b->mining;
}
bool compare_height(Elem &a, Elem &b){
    return a.height < b.height;
}

// n*k log(n*k)
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    for (int a = 0; a < n * k; a++){
        sorted.push_back(Elem(0, 0, a));
        cin >> sorted[a].height >> sorted[a].mining;
    }
    sort(sorted.begin(), sorted.end(), compare_height);

    sorted[0].selected = true;
    long long total_mining_score = sorted[0].mining;
    solution[0].push_back(sorted[0].index);
    std::priority_queue<Elem *, std::vector<Elem *>, std::function<bool(Elem *, Elem *)>> pool(compare_mining);
    for (int i = 0; i < k - 1; i++){
        for (int j = 0; j < n; j++) pool.push(&sorted[i * n + 1 + j]);
        pool.top()->selected = true;
        solution[i+1].push_back(pool.top()->index);
        total_mining_score += pool.top()->mining;
        pool.pop();
    }

    int cur_day = 0;
    for (int a = 0; a < n * k; a++){
        if (sorted[a].selected) continue;
        if (solution[cur_day].size() == n) cur_day++;
        solution[cur_day].push_back(sorted[a].index);
    }

    cout << total_mining_score << "\n";
    return 0;
}