// classical greedy algo for maximum weight basis of a matroid, use segtree as oracle
#include <bits/stdc++.h>
using namespace std;
using ll = long long;
#define sz(x) (int)size(x)
#define all(x) (x).begin(), (x).end()
constexpr ll inf = 1e18;

struct SegTree {
	using T = ll; using U = ll;
	int n;
	static constexpr T E = inf; // Neutral element for combine
	static constexpr U UF = 0; // Unused value by updates
	vector<T> tree;
	int h;
	vector<U> lazy;
	vector<int> k; // size of segments (optional)

	SegTree(const vector<T>& a) : n(sz(a) + 1), tree(2 * n, E),
	//SegTree(int size, T def = E) : n(size + 1), tree(2 * n, def),
			h(__lg(2 * n)), lazy(n, UF), k(2 * n, 1) {
		copy(all(a), tree.begin() + n);
		for (int i = n - 1; i > 0; i--) {
			k[i] = 2 * k[2 * i];
			tree[i] = comb(tree[2 * i], tree[2 * i + 1]);
	}}

	T comb(T a, T b) {return min(a, b);} // Modify this + E

	void apply(int i, U val) { // And this + UF
		tree[i] += val;
		if (i < n) lazy[i] += val; // Don't forget this
	}

	void push_down(int i) {
		if (lazy[i] != UF) {
			apply(2 * i, lazy[i]);
			apply(2 * i + 1, lazy[i]);
			lazy[i] = UF;
	}}

	void push(int i) {
		for (int s = h; s > 0; s--) push_down(i >> s);
	}

	void build(int i) {
		while (i /= 2) {
			push_down(i);
			tree[i] = comb(tree[2 * i], tree[2 * i + 1]);
	}}

	void update(int l, int r, U val) {
		l += n, r += n;
		int l0 = l, r0 = r;
		push(l0), push(r0 - 1);
		for (; l < r; l /= 2, r /= 2) {
			if (l&1) apply(l++, val);
			if (r&1) apply(--r, val);
		}
		build(l0), build(r0 - 1);
	}

	T query(int l, int r) {
		l += n, r += n;
		push(l), push(r - 1);
		T resL = E, resR = E;
		for (; l < r; l /= 2, r /= 2) {
			if (l&1) resL = comb(resL, tree[l++]);
			if (r&1) resR = comb(tree[--r], resR);
		}
		return comb(resL, resR);
	}
};


int main(){
	int n, k;
	cin >> n >> k;
	vector<pair<ll, ll>> v(n*k);
	for(auto &[a, b] : v) cin >> a >> b;
	sort(v.begin(), v.end());
	vector<pair<ll, int>> w;
	for(int i = 0; i < n*k; i++) w.emplace_back(v[i].second, i);
	sort(w.rbegin(), w.rend());
	vector<ll> init(n*k);
	for(int i = 0; i < n*k; i++) init[i] = n*k-i;
	SegTree seg(init);
	ll ans = 0;
	for(auto [x, i] : w){
		seg.update(0, i+1, -n);
		if(seg.query(0, n*k) < 0) seg.update(0, i+1, n);
		else ans += x;
	}
	cout << ans << "\n";
}