#include "validation.h"

// Check the grammar of the input files.
// You should also check properties of the input.
// E.g., check that a graph is connected.

int main(int argc, char *argv[]) {
    InputValidator v(argc, argv);
    int n = v.read_integer("n", 1, 100000);
    v.space();
    int k = v.read_integer("k", 1, 100000);
    v.newline();
    assert(n*k <= 200'000);
    
    std::set<int> heights = {};
    for(int i=0; i<n*k; i++){
        int h = v.read_integer("h_i", 1, 1000000000);
        v.space();
        int m = v.read_integer("m_i", 1, 1000000000);
        v.newline();
        heights.insert(h);
    }

    // Check that all heights are distinct
    if(heights.size() != n*k){
        v.WA("Heights are not all distinct.");
    }
}
