#!/usr/bin/env python3
import random
import sys
from typing import List
import itertools as it

# Init seed with first argument
random.seed(int(sys.argv[1]))

# Generates instances where the mining score increases with height

nmin = int(sys.argv[2])
nmax = int(sys.argv[3])
kmin = int(sys.argv[4])
kmax = int(sys.argv[5])

max_score = int(sys.argv[6])

assert(nmin <= nmax)
n = random.randint(nmin, nmax)
k = random.randint(kmin, kmax)

heights = list(range(1, n * k+1))
scores = []
for i in range(n*k): scores.append(random.randint(1, max_score))
    
# Print in standard format, i.e. one line with the number of values,
# followed by the space-separated values.
zipped = list(zip(heights, scores))
random.shuffle(zipped)

print(f"{n} {k}")
for values in zipped:
    print(f"{values[0]} {values[1]}")
