#!/usr/bin/env python3
import random
import sys
from typing import List
import itertools as it
import argparse



parser = argparse.ArgumentParser()

# either k or kmin and kmax have to be specified
parser.add_argument("--seed")


parser.add_argument("-k", default=-1, type = int)
parser.add_argument("--kmin", default = 1, type = int)
parser.add_argument("--kmax", default = 100000, type=int)

# either n or nmin and nmax have to be specified
parser.add_argument("-n", default=-1, type = int)
parser.add_argument("--nmin", default = 1, type = int)
parser.add_argument("--nmax", default = 100000, type = int)

parser.add_argument("--minval", default = 1, type = int)
parser.add_argument("--maxval", default = 1000000000, type = int)

parser.add_argument("--minprio", default = 1, type=int)
parser.add_argument("--maxprio", default = 1000000000, type=int)

parser.add_argument("--increasing", action="store_true")
parser.add_argument("--decreasing", action="store_true")

args = parser.parse_args()

# Init seed with first argument
random.seed(args.seed)


n = args.n if args.n > 0 else random.randint(args.nmin, args.nmax) 
k = args.k if args.k > 0 else random.randint(args.kmin, args.kmax)


def sample(lower, upper, unique: bool) -> List[int]:
    LARGE = upper - lower >= 1e6
    if unique and not LARGE:
        return random.sample(range(lower, max(upper, lower + n*k) + 1), n * k)
    if unique and LARGE:
        sample = set()
        while len(sample) < n * k:
            sample.add(random.randint(lower, upper))
        return list(sample)
    if not unique:
        sample: List[int] = []
        while len(sample) < n * k:
            sample.append(random.randint(lower, upper))
        return sample

priorities = sample(args.minprio, args.maxprio, unique=True)
scores = sample(args.minval, args.maxval, unique = False)

priorities = sorted(priorities)
if(args.increasing):
    scores = sorted(scores, reverse=True)
elif(args.decreasing):
    scores = sorted(scores)
    
# Print in standard format, i.e. one line with the number of values,
# followed by the space-separated values.
zipped = list(zip(priorities, scores))
random.shuffle(zipped)

print(f"{n} {k}")
for values in zipped:
    print(f"{values[0]} {values[1]}")
