#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

void impossible() {
    cout << "impossible" << '\n';
    exit(0);
}

int main() {
    int n;
    cin >> n;
    vector<vector<int>> d(n, vector<int>(n));
    for (int i = 0; i < n; i++) for (int j = 0; j < n; j++) cin >> d[i][j];
    for (int i = 0; i < n; i++) for (int j = 0; j < n; j++) if (d[i][j] != d[j][i]) impossible();

    vector<int> pos(n); // pos[0] = 0
    pos[1] = d[0][1];
    for (int i = 2; i < n; i++) {
        // find position x:=pos[i], such that |x - pos[1]| = d[1][i] and |x - pos[0]| = |x| = d[0][i]
        // |x| = d[0][i] <=> x = d[0][i] or x = -d[0][i]
        // since d[0][i] != 0, we must have either x - pos[1] = d[1][i] or pos[1] - x = d[1][i]
        if (d[1][i] + pos[1] == d[0][i] || pos[1] - d[1][i] == d[0][i]) pos[i] = d[0][i];
        else if (d[1][i] + pos[1] == -d[0][i] || pos[1] - d[1][i] == -d[0][i]) pos[i] = -d[0][i];
        else impossible();
    }
    for (int i = 0; i < n; i++) for (int j = 0; j < n; j++) if (abs(pos[i] - pos[j]) != d[i][j]) impossible();
    int me = abs(*min_element(pos.begin(), pos.end())) + 1;
    for (int i = 0; i < n; i++) cout << pos[i] + me << " \n"[i+1 == n];
}
