#include "validate.h"
#include <cassert>

using namespace std;

constexpr Integer maxcoord = 10'000'000'000LL;
optional<vector<Integer>> read_answer(InputStream& in, Integer n, OutputValidator::Verdict onFail)
{
	const string ans = in.string();
	if (ans == "impossible") {
		in.newline();
		in.eof();
		return nullopt;
	}

	Integer first;
	if (not details::parse(ans, first))
		OutputValidator::juryOut << "expected Integer or \"impossible\" but got \"" << ans << '\"' << onFail;
	if (first < 1 or first > maxcoord)
		OutputValidator::juryOut << "expected Integer between " << 1 << " and " << maxcoord << ", but got " << '\"' << first << '\"' << onFail;

	if (n > 1)
		in.space();
	auto pos = in.integers(n - 1, 1, maxcoord + 1);
	pos.insert(pos.begin(), first);
	in.newline();
	in.eof();
	return pos;
}

void check(Integer n, const vector<vector<Integer>>& d, const vector<Integer>& pos, Verdicts::Verdict v)
{
	for (Integer i = 0; i < n; i++)
		for (Integer j = 0; j < n; j++)
			if (abs(pos[i] - pos[j]) != d[i][j])
				ValidateBase::juryOut
					<< "distance between " << i + 1 << " and " << j + 1
					<< " should be " << d[i][j] << " but is " << abs(pos[i] - pos[j])
					<< v;
}

int main(int argc, char** argv)
{
	using namespace OutputValidator;
	init(argc, argv);

	const Integer n = testIn.integer(2, 1'000 + 1);
	testIn.newline();
	vector<vector<Integer>> d(n);
	for (int i = 0; i < n; i++) {
		d[i].resize(n);
		for (int j = 0; j < n; j++) {
			if (j)
				testIn.space();
			d[i][j] = testIn.integer(i == j ? 0 : 1, maxcoord + 1);
		}
		testIn.newline();
	}
	testIn.eof();

	const auto jury = read_answer(juryAns, n, FAIL);
	if (jury)
		check(n, d, *jury, FAIL);
	const auto team = read_answer(teamAns, n, WA);
	if (team)
		check(n, d, *team, WA);
	if (team and not jury)
		juryOut << "Oh no! Team found solution but jury didn't!" << FAIL;
	if (jury and not team)
		juryOut << "Team found no solution, but jury has one" << WA;

	juryOut << "OK" << AC;
}
