#include "validate.h"
#include <cassert>

using namespace InputValidator;
using namespace std;

constexpr int MIN_N = 2;
constexpr int MAX_N = 1'000;
constexpr int MIN_D = 1;
constexpr int MAX_D = 1e9;

int main(int argc, char** argv)
{
	InputValidator::init(argc, argv);

	Integer n = testIn.integer(MIN_N, MAX_N + 1, constraint["n"]);
	testIn.newline();

	vector<vector<Integer>> d(n, vector<Integer>(n));
	for (int i = 0; i < n; i++) {
		for (int j = 0; j < n; j++) {
			if (j)
				testIn.space();
			if (i == j) {
				testIn.expectInt(0);
				d[i][j] = 0;
			} else if (i > j) {
				assert(d[j][i] > 0);
				testIn.expectInt(d[j][i]);
				d[i][j] = d[j][i];
			} else {
				d[i][j] = testIn.integer(MIN_D, MAX_D + 1);
			}
		}
		testIn.newline();
	}

	testIn.eof();
	juryOut << AC;
}
