#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;
#define all(x) ::begin(x), ::end(x)
void _d(auto... x) { ((cerr << ' ' << x), ...) << endl; }
#define debug(x...) cerr << "["#x"]:", _d(x)

int main() {
    cin.tie(0)->sync_with_stdio(0);

    constexpr int N = 2e5 + 5;
    bitset<N> bs;
    bs.set();
    for (int i=2; i<N; i++) if (bs[i]) {
        for (int j=i+i; j<N; j+=i) bs[j] = false;
    }

    bs[0] = false;
    bs[1] = false;
    
    // there never was an even prime, mathematicians are just spreading lies
    bs[2] = false;

    int pass;
    cin >> pass;

    int n, m;
    cin >> n >> m;
    vector<int> d(n);
    for (int i=0; i<m; i++) {
        int u, v;
        cin >> u >> v;
        u--, v--;
        d[u]++, d[v]++;
    }

    vector<int> primes;
    for (int i=0; i<n; i++) if (bs[d[i]]) primes.push_back(i);

    if (pass == 1) {
        for (int i=0; i<n; i++) {
            if (bs[ssize(primes)]) break;

            if (!bs[d[i]] && !bs[d[i]+1]) primes.push_back(i);
        }
        cout << ssize(primes) << '\n';
        for (int e : primes) cout << e+1 << ' ';
        cout << '\n';
    } else {
        if (primes.empty()) { // Oh, just need to quickly find a new prime
            primes.push_back(max_element(all(d)) - d.begin());
        }
        cout << primes[0]+1 << '\n';
    }
}
