import Control.Monad
import Data.Array
import Data.Graph
import Data.Maybe
import qualified Data.ByteString.Char8 as B

readInts :: IO [Int]
readInts = map (fst . fromJust . B.readInt) . B.words <$> B.getLine 

main :: IO ()
main = do
  [p] <- readInts
  [n, m] <- readInts
  edges <- replicateM m $ (\[a, b] -> (a, b)) <$> readInts
  let g = buildG (1, n) $ concatMap (\(a, b) -> [(a, b), (b, a)]) edges
      ts = dff g
  if p == 1
     then do
       let xs = if length ts == 1 then [] else [1..n]
       print $ length xs
       putStrLn $ unwords $ map show xs
     else do
       let x = head [x | x <- [1..n], length (g!x) == n-1]
           y = let Node y _ = head [t | t <- ts, length t == 1] in y
       print $ if length ts == 1 then x else y
