#include "validate.h"

int main(int argc, char **argv) {
	OutputValidator::init(argc, argv);
	Multipass::init();
	using namespace OutputValidator;
	using namespace Multipass;

	Integer currentPass = testIn.integer();
	testIn.newline();
	judgeAssert(currentPass == pass+1, "incorrect pass number in testcase");
	if(pass == 0){
		Integer n = testIn.integer();
		Integer m = testIn.integer();
		std::vector<std::pair<Integer, Integer>> edges;
		for(Integer i = 0; i < m; i++){
			Integer u = testIn.integer() - 1;
			Integer v = testIn.integer() - 1;
			edges.emplace_back(u, v);
		}
		Integer deg = teamAns.integer();
		teamAns.newline();
		std::set<Integer> nei;
		for(Integer i = 0; i < deg; i++){
			Integer v = teamAns.integer(1, n+1);
			if(i < deg-1) teamAns.space();
			else teamAns.newline();
			if(nei.contains(v)){
				teamOut << "WA multiedge" << WA;
			}
			nei.insert(v);
			edges.emplace_back(v-1, n);
		}
		teamAns.eof();
		Random::shuffle(edges);
		std::vector<Integer> p = Random::perm(n+1);
		nextstate << p[n]+1 << std::endl;
		nextpass << 2 << std::endl;
		nextpass << n+1 << " " << edges.size() << std::endl;
		for(auto [u, v] : edges){
			if(Random::bit()) std::swap(u, v);
			nextpass << p[u]+1 << " " << p[v]+1 << std::endl;
		}
		NEXT();
	}
	else{
		Integer correct = prevstate.integer();
		prevstate.newline();
		prevstate.eof();
		Integer out = teamAns.integer();
		teamAns.newline();
		teamAns.eof();
		if(correct == out){
			teamOut << "Correct." << AC;
		}
		else{
			teamOut << "WA" << WA;
		}
	}
}
