#include "validate.h"
using namespace std;

constexpr Integer MAXN = 1e5;
constexpr Integer MAXM = 2e5;

int main(int argc, char **argv) {
	InputValidator::init(argc, argv);
	using namespace InputValidator;

	Integer pass = testIn.integer(1, 2);
	testIn.newline();
	Integer n = testIn.integer(2, MAXN+1);
	testIn.space();
	Integer m = testIn.integer(0, MAXM+1);
	testIn.newline();
	set<pair<int, int>> edges;
	for(Integer i = 0; i < m; i++){
		Integer u = testIn.integer(1, n+1);
		testIn.space();
		Integer v = testIn.integer(1, n+1);
		testIn.newline();
		if(u == v) juryOut << "self-edge" << WA;
		if(u > v) swap(u, v);
		if(edges.contains({u, v})) juryOut << "duplicate edge" << WA;
		edges.emplace(u, v);
	}
	testIn.eof();

	juryOut << "OK!" << AC;
}
