#include "validate.h"
using namespace InputValidator;
using namespace std;

constexpr int MIN_N = 1;
constexpr int MAX_N = 200'000;
constexpr int MIN_COST = 1;
constexpr int MAX_COST = 1e9;

int main(int argc, char **argv) {
    InputValidator::init(argc, argv);

    Integer n = testIn.integer(MIN_N, MAX_N + 1, constraint["n"]);
    testIn.space();
    testIn.integer(MIN_COST, MAX_COST + 1, constraint["x"]);
    testIn.space();
    testIn.integer(MIN_COST, MAX_COST + 1, constraint["r"]);
    testIn.space();
    testIn.integer(1, n + 1, constraint["d"]);
    testIn.newline();

    testIn.integers(n, 0, 2);
    testIn.newline();
    testIn.eof();

    juryOut << AC;
}
