#include <bits/stdc++.h>
using namespace std;
using ll = int64_t;
#define all(x) ::begin(x), ::end(x)
void _d(auto... x) { ((cerr << ' ' << x), ...) << endl; }
#define debug(x...) cerr << "["#x"]:", _d(x)

#define sz(x) ssize(x)
struct SuffixTree {
	struct Vert {
		int start, end, suf; //s[start...end) along parent edge
		map<char, int> nxt;
	};
	string s;
	int needsSuffix, pos, remainder, curVert, curEdge, curLen;
	// Each Vertex gives its children range as [start, end)
	vector<Vert> tree = {Vert{-1, -1, 0, {}}};

	SuffixTree(const string& s_) : s(s_) {
		needsSuffix = remainder = curVert = curEdge = curLen = 0;
		pos = -1;
		for (int i = 0; i < sz(s); i++) extend();
	}

	int newVert(int start, int end) {
		tree.push_back({start, end, 0, {}});
		return sz(tree) - 1;
	}

	void addSuffixLink(int vert) {
		if (needsSuffix) tree[needsSuffix].suf = vert;
		needsSuffix = vert;
	}

	bool fullImplicitEdge(int vert) {
		int len = min(tree[vert].end, pos + 1) - tree[vert].start;
		if (curLen >= len) {
			curEdge += len;
			curLen -= len;
			curVert = vert;
			return true;
		} else {
			return false;
	}}

	void extend() {
		pos++;
		needsSuffix = 0;
		remainder++;
		while (remainder) {
			if (curLen == 0) curEdge = pos;
			if (!tree[curVert].nxt.count(s[curEdge])) {
				int leaf = newVert(pos, sz(s));
				tree[curVert].nxt[s[curEdge]] = leaf;
				addSuffixLink(curVert);
			} else {
				int nxt = tree[curVert].nxt[s[curEdge]];
				if (fullImplicitEdge(nxt)) continue;
				if (s[tree[nxt].start + curLen] == s[pos]) {
					curLen++;
					addSuffixLink(curVert);
					break;
				}
				int split = newVert(tree[nxt].start,
				                    tree[nxt].start + curLen);
				tree[curVert].nxt[s[curEdge]] = split;
				int leaf = newVert(pos, sz(s));
				tree[split].nxt[s[pos]] = leaf;
				tree[nxt].start += curLen;
				tree[split].nxt[s[tree[nxt].start]] = nxt;
				addSuffixLink(split);
			}
			remainder--;
			if (curVert == 0 && curLen) {
				curLen--;
				curEdge = pos - remainder + 1;
			} else {
				curVert = tree[curVert].suf ? tree[curVert].suf : 0;
	}}}
};

vector<int> Z(const string& s) {
	int n = sz(s);
	vector<int> z(n);
	for (int i = 1, x = 0; i < n; i++) {
		z[i] = max(0, min(z[i - x], x + z[x] - i));
		while (i + z[i] < n && s[z[i]] == s[i + z[i]]) {
			x = i, z[i]++;
	}}
	return z;
}

int get_period(string s) {
    auto z = Z(s);
    for (int i=1; i<ssize(s); i++) if (z[i] + i == ssize(s)) {
        return i;
    }
    return ssize(s);
}

int main() {
    cin.tie(0)->sync_with_stdio(0);

    int n, l;
    string s;
    cin >> n >> l >> s;

    SuffixTree st(s + "$");

    int m = ssize(st.tree);
    vector<set<int>> dp(m);
    vector<int> dp_cnt(m), pre_cnt(n);
    vector<int> d(m), val(m);
    vector<int> per(n), first(n);
    for (int i=0; i<n; i++) per[i] = min(l, n - i);
    auto dfs = [&](auto& self, int u) -> void {
        for (auto [c, v] : st.tree[u].nxt) {
            if (c == '$' && d[u] < l) {
                val[u] = max(val[u], d[u]);
            }
        }

        for (auto [c, v] : st.tree[u].nxt) {
            d[v] = d[u] + st.tree[v].end - st.tree[v].start;
            val[v] = val[u];
            self(self, v);
            dp_cnt[u] += dp_cnt[v];

            if (ssize(dp[v]) > ssize(dp[u])) swap(dp[u], dp[v]);
            for (int e : dp[v]) {
                dp[u].insert(e);
                auto it = dp[u].lower_bound(max(min(e + l, n) - d[u], e+1));
                if (it != dp[u].end()) {
                    per[e] = min(per[e], *it - e);
                }

                int le = e - l + 1;
                int ri = e + min(d[u], l-1);
                if (ri == n) ri = e;
                else ri -= l - 1;
                it = dp[u].lower_bound(ri);
                if (it == dp[u].begin()) continue;
                it--;

                while (le <= *it) {
                    assert(min(*it + l, n) <= e + d[u]);
                    per[*it] = min(per[*it], e - *it);
                    it++;
                    break;
                }
            }
        }

        if (st.tree[u].nxt.empty() && d[u] != 1) {
            int pos = n + 1 - d[u];
            dp[u].insert(pos);
            first[pos] = n - val[u]; 
            if (pos > n - l) first[pos] = pos;
            else dp_cnt[u]++;
        }
    };
    dfs(dfs, 0);

    auto dfs2 = [&](auto& self, int u) -> void {
        for (auto [c, v] : st.tree[u].nxt) {
            if (d[u] >= l) dp_cnt[v] = dp_cnt[u];
            self(self, v);
        }
        if (st.tree[u].nxt.empty() && d[u] > l) {
            pre_cnt[n + 1 - d[u]] = dp_cnt[u];
        }
    };
    dfs2(dfs2, 0);

    int best = -1, mx = -1;
    for (int i=0; i<n; i++) {
        int cnt = pre_cnt[i];
        int p = first[i] + l;
        if (p < n + l) {
            cnt += ((n + l - 1) - p) / per[i];
            if (cnt > mx) mx = cnt, best = i;
        }
    }

    assert(best != -1);
    string ans = s + string(l-1, 'z');
    int p = first[best];
    while (p + per[best] < n) p += per[best];
    for (int i=0; i<l; i++) ans[p+i] = s[best + (i % per[best])];

    cout << ans << '\n';
}
