#include <bits/stdc++.h>
using namespace std;
#define sz(x) (int)size(x)
#define all(x) (x).begin(), (x).end()
constexpr int MAX_TRIES = 20;
constexpr int inf = 1e9;

constexpr int MAX_CHAR = 256;
struct SuffixArray {
	int n;
	vector<int> SA, LCP;
	vector<vector<int>> P;

	SuffixArray(const string& s) : n(sz(s)), SA(n), LCP(n),
		P(__lg(2 * n - 1) + 1, vector<int>(n)) {
		P[0].assign(all(s));
		iota(all(SA), 0);
		sort(all(SA), [&](int a, int b) {return s[a] < s[b];});
		vector<int> x(n);
		for (int k = 1, c = 1; c < n; k++, c *= 2) {
			iota(all(x), n - c);
			for (int ptr = c; int i : SA) if (i >= c) x[ptr++] = i - c;

			vector<int> cnt(k == 1 ? MAX_CHAR : n);
			for (int i : P[k-1]) cnt[i]++;
			partial_sum(all(cnt), begin(cnt));
			for (int i : x | views::reverse) SA[--cnt[P[k-1][i]]] = i;

			auto p = [&](int i) {return i < n ? P[k-1][i] : -1;};
			for (int i = 1; i < n; i++) {
				int a = SA[i-1], b = SA[i];
				P[k][b] = P[k][a] + (p(a) != p(b) || p(a+c) != p(b+c));
		}}
		for (int i = 1; i < n; i++) LCP[i] = lcp(SA[i-1], SA[i]);
	}

	int lcp(int x, int y) {//x & y are text-indices, not SA-indices
		if (x == y) return n - x;
		int res = 0;
		for (int i = sz(P) - 1; i >= 0 && max(x, y) + res < n; i--) {
			if (P[i][x + res] == P[i][y + res]) res |= 1 << i;
		}
		return res;
	}
};

vector<int> prefun(string s){
	vector<int> p(sz(s));
	for(int i = 1, j = 0; i < sz(s); i++){
		while(j > 0 && s[j] != s[i]) j = p[j-1];
		if(s[j] == s[i]) j++;
		p[i] = j;
	}
	return p;
}

int main(){
	int n, k;
	cin >> n >> k;
	string s;
	cin >> s;

	// new substrings
	int ans = 0, cpind = 0, cpper = 0, startInd = 0;
	vector<int> oldPref;
	{
		string t = s.substr(n-k, k);
		reverse(all(t));
		vector<int> p = prefun(t);
		oldPref = p;
		for(int i = 1; i < k; i++){
			int per = i - p[i-1];
			int cnt = (i+per-1)/per;
			if(cnt > ans){
				ans = cnt;
				cpind = n-i;
				cpper = per;
				startInd = n-i;
			}
		}
	}
	// count already existing substrings
	SuffixArray sa(s);
	vector<int> cnt(n-k+1);
	for(int i = 0, j = 0; i < n; i++){
		j = max(i, j);
		while(j < n-1 && sa.LCP[j+1] >= k) j++;
		if(sa.SA[i] <= n-k) cnt[sa.SA[i]] = j-i+1;
	}
	// instead of actually solving sliding window period,
	// only try small periods
	{
		string t = s + "#" + s.substr(n-k+1);
		reverse(all(t));
		vector<int> p = prefun(t);
		for(int i = 0; i <= n-k; i++){
			int cn = cnt[i];
			int x = p.end()[-i-1];
			if(x == 0) continue;
			int pe_guess = 1;
			for(int tries = 0; tries < MAX_TRIES; tries++){
				if(tries == MAX_TRIES - 1) pe_guess = k;
				if(sa.lcp(i, i+pe_guess) >= k-pe_guess){
					int pe = pe_guess;
					cn += (x+pe-1) / pe;
					if(cn > ans){
						ans = cn;
						cpind = i;
						cpper = pe;
						startInd = n-x;
					}
					break;
				}
				pe_guess++;
			}
		}
	}

	cerr << ans << "\n";
	s.resize(n+k-1);
	for(int i = startInd; i < sz(s); i++){
		char c = s[cpind + (i-startInd)%cpper];
		if(i < n) assert(c == s[i]);
		s[i] = c;
	}
	cout << s << "\n";
}