#include <algorithm>
#include <cassert>
#include <cstdint>
#include <iostream>
#include <numeric>
#include <optional>
#include <set>
#include <stack>
#include <vector>

using namespace std;
#define sz(a) ((int)((a).size()))
#define all(a) (a).begin(), (a).end()
using vi = vector<int>;
using pii = pair<int, int>;
using u64 = uint64_t;

void sais(const auto* S, int* sa, const int n)
{
	vi C(max(n, 256));
	fill_n(sa, n, 0);

	const auto Ccnt = [&] {
		fill(all(C), 0);
		for (int i = 0; i < n; i++)
			C[S[i]]++;
	};
	const auto Cend = [&] {
		Ccnt();
		partial_sum(all(C), C.begin());
	};

	vector<bool> type(n, true), isLMS(n);
	for (int i = n - 1; i-- > 0;)
		type[i] = S[i] < S[i + 1] + type[i + 1];
	for (int i = 1; i < n; i++)
		isLMS[i] = type[i] and not type[i - 1];

	const auto induceLS = [&] {
		Ccnt();
		exclusive_scan(all(C), C.begin(), 0);

		for (int i = 0; i < n; i++)
			if (int pre = sa[i] - 1; pre >= 0 and not type[pre])
				sa[C[S[pre]]++] = pre;

		Cend();
		for (int i = n; i-- > 0;)
			if (int pre = sa[i] - 1; pre >= 0 and type[pre])
				sa[--C[S[pre]]] = pre;
	};

	Cend();
	for (int i = 1; i < n; i++)
		if (isLMS[i])
			sa[--C[S[i]]] = i;

	induceLS();
	int m = 0;
	for (int i = 0; i < n; i++)
		if (isLMS[sa[i]])
			sa[m++] = sa[i];
	sa[m + sa[0] / 2] = 0;
	int name = 1;
	for (int i = 1; i < m; i++, name++) {
		int l = 0, a = sa[i - 1], b = sa[i];
		for (; S[a + l] == S[b + l] and isLMS[a + l] == isLMS[b + l]; l++)
			if (l > 0 && isLMS[a + l]) {
				name--;
				break;
			}
		sa[m + b / 2] = name;
	}
	Cend();
	if (m > name) {
		for (int k = 0, i = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = sa[m + i / 2];
		sais(sa, sa + n - m, m);
		for (int i = 0, k = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = i, C[S[i]]--;
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[sa[i + n - m]];
	} else {
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[i], C[S[sa[i]]]--;
	}
	fill_n(sa, n - m, 0);
	for (int i = 0; i < m; i++) {
		int lms = sa[i + n - m];
		sa[i + n - m] = 0;
		sa[C[S[lms]]++] = lms;
	}
	induceLS();
}
vi kasai(const char* S, const int* SA, const int* ISA, int n)
{
	vi LCP(n);
	LCP[0] = -1;
	for (int i = 0, lcp = 0; i < n - 1; i++) {
		while (S[i + lcp] == S[SA[ISA[i] - 1] + lcp])
			lcp++;
		LCP[ISA[i]] = lcp;
		lcp = max(lcp - 1, 0);
	}
	return LCP;
}
struct ESA {
	string s;
	vi SA, ISA, LCP;
};
ESA build_esa(string_view s)
{
	assert(s.back() == '$');
	ESA res;
	res.s = s;
	res.ISA = res.SA = vi(sz(s));
	sais(&res.s[0], &res.SA[0], sz(s));
	for (int i = 0; i < sz(s); i++)
		res.ISA[res.SA[i]] = i;
	res.LCP = kasai(&res.s[0], &res.SA[0], &res.ISA[0], sz(s));
	return res;
}
struct lcp_tree {
	int lcp, lb, rb;
	vector<lcp_tree> children;
};
lcp_tree lcp_interval_tree(const ESA& esa)
{
	const int n = sz(esa.s);
	stack<lcp_tree> st;
	st.emplace(lcp_tree { -1, 0, n, {} });
	for (int i = 1; i <= n; i++) {
		st.emplace(lcp_tree { n, i - 1, n, {} });
		const int lcp = i < n ? esa.LCP[i] : -1;
		int lb = i - 1;
		optional<lcp_tree> last;
		while (lcp < st.top().lcp) {
			st.top().rb = i - 1;
			last = std::move(st.top());
			st.pop();
			lb = last->lb;
			if (lcp <= st.top().lcp) {
				st.top().children.emplace_back(std::move(*last));
				last = nullopt;
			}
		}
		if (lcp > st.top().lcp) {
			st.emplace(lcp_tree { lcp, lb, n, {} });
			if (last)
				st.top().children.emplace_back(std::move(*last));
		}
	}
	return st.top();
}
vi periods(const ESA& esa, const int l)
{
	vi per(sz(esa.s), l);
	const auto check = [&](int i, int j, int lcp) {
		assert(i < j);
		if (j + lcp >= i + l)
			per[i] = min(per[i], j - i);
	};
	auto dfs = [&](auto&& self, const lcp_tree& t) -> set<int> {
		set<int> cur;
		if (t.lb == t.rb) {
			cur.emplace(esa.SA[t.lb]);
			return cur;
		}
		for (const lcp_tree& c : t.children) {
			set<int> tmp = self(self, c);
			if (sz(cur) < sz(tmp))
				swap(cur, tmp);
			for (int i : tmp) {
				auto it = cur.insert(i).first;
				if (it != cur.begin())
					check(*prev(it), i, t.lcp);
				if (auto n = next(it); n != cur.end())
					check(i, *n, t.lcp);
			}
		}
		return cur;
	};
	auto t = lcp_interval_tree(esa);
	dfs(dfs, t);
	return per;
}

int main()
{
	ios::sync_with_stdio(false), cin.tie(nullptr);
	int n, l;
	string s;
	cin >> n >> l >> s;
	s += '$', n++;

	ESA fwd = build_esa(s);
	reverse(&s[0], &s[n - 1]);
	ESA rev = build_esa(s);
	reverse(&s[0], &s[n - 1]);

	vi per = periods(fwd, l);

	vi suffix_match(n); // for each i, find longest prefix of S[i, i + l) that is suffix of S
	{
		vi prefix_match(n);
		prefix_match[n - 2 - 0] = n;
		for (int i = rev.ISA[0] + 1, lcp = n; i < n; i++)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i]);
		for (int i = rev.ISA[0] - 1, lcp = n; i > 0; i--)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i + 1]);

		for (int p = 0; p < n; p++) {
			prefix_match[p] = min(prefix_match[p], l - 1);
			int i = p - prefix_match[p] + 1;
			assert(0 <= i and i <= n);
			if (i == n)
				continue;
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], prefix_match[p]);
		}

		for (int i = 1; i < n; i++)
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], suffix_match[fwd.ISA[i - 1]] - 1);

		stack<int> st;
		for (int i = 0; i < n; i++) {
			const int j = fwd.SA[i], len = n - 1 - j;
			if (len == 0)
				continue;
			while (not st.empty() and st.top() > fwd.LCP[i])
				st.pop();
			if (len < l) {
				suffix_match[i] = st.empty() ? 0 : st.top();
				per[j] = min(per[j], len - suffix_match[i]);
				st.emplace(len);
			}
		}
	}

	pii res { 0, 0 };
	for (int i = 1; i < n;) {
		int j = i + 1;
		while (j < n and fwd.LCP[j] >= l)
			j++;

		int cnt = j - i;

		if (int dist = suffix_match[j - 1] + l - 1; dist >= l)
			cnt += 1 + (dist - l) / per[fwd.SA[i]];
		res = max(res, pii { cnt, j - 1 });
		i = j;
	}

	s.pop_back();
	cout << s;
	int j = res.second;
	int len = per[fwd.SA[j]];
	for (int i = 0; i < l - 1; i++)
		cout << s[fwd.SA[j] + (suffix_match[j] + i) % len];
	cout << endl;
}
