#include <algorithm>
#include <cassert>
#include <cstdint>
#include <iostream>
#include <map>
#include <numeric>
#include <random>
#include <stack>
#include <vector>

using namespace std;
#define sz(a) ((int)((a).size()))
#define all(a) (a).begin(), (a).end()
using vi = vector<int>;
using pii = pair<int, int>;
using u64 = uint64_t;

void sais(const auto* S, int* sa, const int n)
{
	vi C(max(n, 256));
	fill_n(sa, n, 0);

	const auto Ccnt = [&] {
		fill(all(C), 0);
		for (int i = 0; i < n; i++)
			C[S[i]]++;
	};
	const auto Cend = [&] {
		Ccnt();
		partial_sum(all(C), C.begin());
	};

	vector<bool> type(n, true), isLMS(n);
	for (int i = n - 1; i-- > 0;)
		type[i] = S[i] < S[i + 1] + type[i + 1];
	for (int i = 1; i < n; i++)
		isLMS[i] = type[i] and not type[i - 1];

	const auto induceLS = [&] {
		Ccnt();
		exclusive_scan(all(C), C.begin(), 0);

		for (int i = 0; i < n; i++)
			if (int pre = sa[i] - 1; pre >= 0 and not type[pre])
				sa[C[S[pre]]++] = pre;

		Cend();
		for (int i = n; i-- > 0;)
			if (int pre = sa[i] - 1; pre >= 0 and type[pre])
				sa[--C[S[pre]]] = pre;
	};

	Cend();
	for (int i = 1; i < n; i++)
		if (isLMS[i])
			sa[--C[S[i]]] = i;

	induceLS();
	int m = 0;
	for (int i = 0; i < n; i++)
		if (isLMS[sa[i]])
			sa[m++] = sa[i];
	sa[m + sa[0] / 2] = 0;
	int name = 1;
	for (int i = 1; i < m; i++, name++) {
		int l = 0, a = sa[i - 1], b = sa[i];
		for (; S[a + l] == S[b + l] and isLMS[a + l] == isLMS[b + l]; l++)
			if (l > 0 && isLMS[a + l]) {
				name--;
				break;
			}
		sa[m + b / 2] = name;
	}
	Cend();
	if (m > name) {
		for (int k = 0, i = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = sa[m + i / 2];
		sais(sa, sa + n - m, m);
		for (int i = 0, k = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = i, C[S[i]]--;
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[sa[i + n - m]];
	} else {
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[i], C[S[sa[i]]]--;
	}
	fill_n(sa, n - m, 0);
	for (int i = 0; i < m; i++) {
		int lms = sa[i + n - m];
		sa[i + n - m] = 0;
		sa[C[S[lms]]++] = lms;
	}
	induceLS();
}
vi kasai(const char* S, const int* SA, const int* ISA, int n)
{
	vi LCP(n);
	LCP[0] = -1;
	for (int i = 0, lcp = 0; i < n - 1; i++) {
		while (S[i + lcp] == S[SA[ISA[i] - 1] + lcp])
			lcp++;
		LCP[ISA[i]] = lcp;
		lcp = max(lcp - 1, 0);
	}
	return LCP;
}
struct rmq {
	u64 n = 0;
	vector<int> b; // b[i+j*n]: min of arr[i..i+2^j-1]
	rmq() = default;
	rmq(u64 n, const int* a)
	{
		this->n = n;
		u64 l = max<int>(1, bit_width(n));
		b.resize(l * n);
		for (u64 i = 0; i < n; i++)
			b[i + 0 * n] = a[i];
		for (u64 j = 1, pl = 1, len = 2; len <= n; pl = len, len *= 2, j++) {
			assert(j < l);
			for (u64 i = 0; i <= n - len; i++) {
				b[i + j * n] = min(b[i + (j - 1) * n], b[i + pl + (j - 1) * n]);
			}
		}
	}
	int query(u64 from, u64 to) const // min of arr[from..to]
	{
		assert(to >= from);
		u64 d2 = 63 - countl_zero((u64)(to + 1 - from));
		assert((1ll << d2) <= to + 1 - from);
		assert((1ll << d2) * 2 > to + 1 - from);
		return min(b[d2 * n + from], b[d2 * n + to - (1ll << d2) + 1]);
	}
};
struct linear_rmq {
	using u64 = uint64_t;
	vector<u64> mask;
	rmq bs;
	vi a;
	int block(u64 r, u64 k = 64) const
	{
		u64 i = r + countl_zero(k == 64 ? mask[r] : mask[r] & ((1ull << k) - 1)) - 63;
		return a[i];
	}
	linear_rmq() = default;
	linear_rmq(u64 n, const int* _a)
		: a(_a, _a + n)
	{
		u64 m = 0;
		for (u64 i = 0; i < n; i++, m <<= 1) {
			while (m > 0 and a[i] < a[i - countr_zero(m)])
				m &= m - 1;
			mask.emplace_back(m |= 1);
		}
		for (u64 i = 0; i < 64; i++, m <<= 1)
			mask.emplace_back(m);
		vi tmp;
		for (u64 i = 0; i < n / 64; i++)
			tmp.emplace_back(block((i + 1) * 64 - 1));
		bs = rmq(sz(tmp), tmp.data());
	}
	int query(int l, int r) const // min of arr[from..to]
	{
		if (r + 1 - l <= 64)
			return block(r, r - l + 1);
		int res = min(block(l + 64 - 1), block(r));
		int bl = l / 64 + 1, br = r / 64 - 1;
		if (bl <= br)
			res = min(res, bs.query(bl, br));
		return res;
	}
};
struct ESA {
	string s;
	vi SA, ISA, LCP;
};
ESA build_esa(string_view s)
{
	assert(s.back() == '$');
	ESA res;
	res.s = s;
	res.ISA = res.SA = vi(sz(s));
	sais(&res.s[0], &res.SA[0], sz(s));
	for (int i = 0; i < sz(s); i++)
		res.ISA[res.SA[i]] = i;
	res.LCP = kasai(&res.s[0], &res.SA[0], &res.ISA[0], sz(s));
	return res;
}
struct LCP_t {
	linear_rmq s;
	const int* ISA = nullptr;
	LCP_t() = default;
	LCP_t(const ESA& esa)
		: s(sz(esa.s), &esa.LCP[0])
		, ISA(&esa.ISA[0])
	{
	}
	int operator()(int l, int r) const
	{
		assert(l != r);
		if (ISA[l] > ISA[r])
			swap(l, r);
		return s.query(ISA[l] + 1, ISA[r]);
	}
};

// finds all periods where the root repeats twice (i.e. the exponent is >= 2)
vi periods(const ESA& esa, auto&& lcp, auto&& rev_lcp, const int l)
{
	const int n = sz(esa.s);

	vector<vector<pair<int, int>>> rs(n);
	const auto emit = [&](int i, int j) {
		// s[i..j) is Lyndon
		int j2 = j + lcp(i, j);
		int i2 = i - rev_lcp(n - 1 - i, n - 1 - j);
		int p = j - i;
		// s[i2..j2) is a run with period p
		if (j2 - i2 >= l and p < l)
			rs[i2].emplace_back(p, j2);
	};
	stack<int> st;
	st.emplace(n - 1);
	for (int i = n - 1; i-- > 0;) {
		emit(i, st.top());
		while (esa.ISA[st.top()] > esa.ISA[i]) {
			st.pop();
			emit(i, st.top());
		}
		st.emplace(i);
	}

	vi per(n, l);
	map<int, int> cur; // (p, j)
	for (int i = 0; i + 1 < n; i++) {
		while (not cur.empty() and cur.begin()->second - i < l)
			cur.erase(cur.begin());
		for (auto [p, j] : rs[i]) {
			auto [it, succ] = cur.emplace(p, j);
			if (not succ)
				it->second = max(it->second, j);
		}
		if (not cur.empty())
			per[i] = cur.begin()->first;
		per[i] = min(per[i], n - 1 - i);
	}
	return per;
}

int main()
{
	ios::sync_with_stdio(false), cin.tie(nullptr);
	int n, l;
	string s;
	cin >> n >> l >> s;
	s += '$', n++;

	ESA fwd = build_esa(s);
	reverse(&s[0], &s[n - 1]);
	ESA rev = build_esa(s);
	reverse(&s[0], &s[n - 1]);

	vi per = periods(fwd, LCP_t(fwd), LCP_t(rev), l);
	{
		for (int i = 0; i < sz(s) - 1; i++)
			s[i] = 'a' + ('z' - s[i]);
		ESA fwd = build_esa(s);
		reverse(&s[0], &s[n - 1]);
		ESA rev = build_esa(s);
		reverse(&s[0], &s[n - 1]);
		vi p2 = periods(fwd, LCP_t(fwd), LCP_t(rev), l);
		for (int i = 0; i < sz(per); i++)
			per[i] = min(per[i], p2[i]);
		for (int i = 0; i < sz(s) - 1; i++)
			s[i] = 'a' + ('z' - s[i]);
	}

	vi suffix_match(n); // for each i, find longest prefix of S[i, i + l) that is suffix of S
	{
		vi prefix_match(n);
		prefix_match[n - 2 - 0] = n;
		for (int i = rev.ISA[0] + 1, lcp = n; i < n; i++)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i]);
		for (int i = rev.ISA[0] - 1, lcp = n; i > 0; i--)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i + 1]);

		for (int p = 0; p < n; p++) {
			prefix_match[p] = min(prefix_match[p], l - 1);
			int i = p - prefix_match[p] + 1;
			assert(0 <= i and i <= n);
			if (i == n)
				continue;
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], prefix_match[p]);
		}

		for (int i = 1; i < n; i++)
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], suffix_match[fwd.ISA[i - 1]] - 1);

		stack<int> st;
		for (int i = 0; i < n; i++) {
			const int j = fwd.SA[i], len = n - 1 - j;
			if (len == 0)
				continue;
			while (not st.empty() and st.top() > fwd.LCP[i])
				st.pop();
			if (len < l) {
				suffix_match[i] = st.empty() ? 0 : st.top();
				per[j] = min(per[j], len - suffix_match[i]);
				st.emplace(len);
			}
		}
	}

	pii res { 0, 0 };
	for (int i = 1; i < n;) {
		int j = i + 1;
		while (j < n and fwd.LCP[j] >= l)
			j++;

		int cnt = j - i;

		if (int dist = suffix_match[j - 1] + l - 1; dist >= l)
			cnt += 1 + (dist - l) / per[fwd.SA[i]];
		res = max(res, pii { cnt, j - 1 });
		i = j;
	}

	s.pop_back();
	cout << s;
	int j = res.second;
	int len = per[fwd.SA[j]];
	for (int i = 0; i < l - 1; i++)
		cout << s[fwd.SA[j] + (suffix_match[j] + i) % len];
	cout << endl;
}
