
#include <algorithm>
#include <cassert>
#include <cstdint>
#include <iostream>
#include <numeric>
#include <optional>
#include <set>
#include <stack>
#include <vector>

using namespace std;
#define sz(a) ((int)((a).size()))
#define all(a) (a).begin(), (a).end()
using vi = vector<int>;
using pii = pair<int, int>;
using u64 = uint64_t;

void sais(const auto* S, int* sa, const int n)
{
	vi C(max(n, 256));
	fill_n(sa, n, 0);

	const auto Ccnt = [&] {
		fill(all(C), 0);
		for (int i = 0; i < n; i++)
			C[S[i]]++;
	};
	const auto Cend = [&] {
		Ccnt();
		partial_sum(all(C), C.begin());
	};

	vector<bool> type(n, true), isLMS(n);
	for (int i = n - 1; i-- > 0;)
		type[i] = S[i] < S[i + 1] + type[i + 1];
	for (int i = 1; i < n; i++)
		isLMS[i] = type[i] and not type[i - 1];

	const auto induceLS = [&] {
		Ccnt();
		exclusive_scan(all(C), C.begin(), 0);

		for (int i = 0; i < n; i++)
			if (int pre = sa[i] - 1; pre >= 0 and not type[pre])
				sa[C[S[pre]]++] = pre;

		Cend();
		for (int i = n; i-- > 0;)
			if (int pre = sa[i] - 1; pre >= 0 and type[pre])
				sa[--C[S[pre]]] = pre;
	};

	Cend();
	for (int i = 1; i < n; i++)
		if (isLMS[i])
			sa[--C[S[i]]] = i;

	induceLS();
	int m = 0;
	for (int i = 0; i < n; i++)
		if (isLMS[sa[i]])
			sa[m++] = sa[i];
	sa[m + sa[0] / 2] = 0;
	int name = 1;
	for (int i = 1; i < m; i++, name++) {
		int l = 0, a = sa[i - 1], b = sa[i];
		for (; S[a + l] == S[b + l] and isLMS[a + l] == isLMS[b + l]; l++)
			if (l > 0 && isLMS[a + l]) {
				name--;
				break;
			}
		sa[m + b / 2] = name;
	}
	Cend();
	if (m > name) {
		for (int k = 0, i = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = sa[m + i / 2];
		sais(sa, sa + n - m, m);
		for (int i = 0, k = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = i, C[S[i]]--;
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[sa[i + n - m]];
	} else {
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[i], C[S[sa[i]]]--;
	}
	fill_n(sa, n - m, 0);
	for (int i = 0; i < m; i++) {
		int lms = sa[i + n - m];
		sa[i + n - m] = 0;
		sa[C[S[lms]]++] = lms;
	}
	induceLS();
}
vi kasai(const char* S, const int* SA, const int* ISA, int n)
{
	vi LCP(n + 1);
	LCP[0] = LCP[n] = -1;
	for (int i = 0, lcp = 0; i < n - 1; i++) {
		while (S[i + lcp] == S[SA[ISA[i] - 1] + lcp])
			lcp++;
		LCP[ISA[i]] = lcp;
		lcp = max(lcp - 1, 0);
	}
	return LCP;
}
struct ESA {
	string s;
	vi SA, ISA, LCP;
};
ESA build_esa(string_view s)
{
	assert(s.back() == '$');
	ESA res;
	res.s = s;
	res.ISA = res.SA = vi(sz(s));
	sais(&res.s[0], &res.SA[0], sz(s));
	for (int i = 0; i < sz(s); i++)
		res.ISA[res.SA[i]] = i;
	res.LCP = kasai(&res.s[0], &res.SA[0], &res.ISA[0], sz(s));
	return res;
}
struct lcp_tree {
	int lcp, lb, rb;
	vector<lcp_tree> children;
};
lcp_tree lcp_interval_tree(const ESA& esa)
{
	const int n = sz(esa.s);
	stack<lcp_tree> st;
	st.emplace(lcp_tree { -1, 0, n, {} });
	for (int i = 1; i <= n; i++) {
		st.emplace(lcp_tree { n, i - 1, n, {} });
		const int lcp = esa.LCP[i];
		int lb = i - 1;
		optional<lcp_tree> last;
		while (lcp < st.top().lcp) {
			st.top().rb = i - 1;
			last = std::move(st.top());
			st.pop();
			lb = last->lb;
			if (lcp <= st.top().lcp) {
				st.top().children.emplace_back(std::move(*last));
				last = nullopt;
			}
		}
		if (lcp > st.top().lcp) {
			st.emplace(lcp_tree { lcp, lb, n, {} });
			if (last)
				st.top().children.emplace_back(std::move(*last));
		}
	}
	return st.top();
}
vi periods(const ESA& esa, const int l, const lcp_tree& t)
{
	vi per(sz(esa.s), l);
	const auto check = [&](int i, int j, int lcp) {
		assert(i < j);
		assert(j + lcp >= i + l);
		per[i] = min(per[i], j - i);
	};
	auto dfs = [&](auto&& self, const lcp_tree& t) -> set<int> {
		set<int> cur;
		if (t.lb == t.rb) {
			cur.emplace(esa.SA[t.lb]);
			return cur;
		}
		for (const lcp_tree& c : t.children) {
			set<int> tmp = self(self, c);
			if (sz(cur) < sz(tmp))
				swap(cur, tmp);
			for (int i : tmp) {
				cur.emplace(i);
				// find closest j < i s.t. i + lcp >= j + l <=> j <= i + lcp - l
				if (auto it = cur.upper_bound(min(i - 1, i - l + t.lcp)); it != cur.begin())
					check(*prev(it), i, t.lcp);
				// find closest j > i s.t. j + lcp >= i + l <=> j >= i + l - lcp
				if (auto it = cur.lower_bound(max(i + 1, i + l - t.lcp)); it != cur.end())
					check(i, *it, t.lcp);
			}
		}
		return cur;
	};
	dfs(dfs, t);
	return per;
}

// all suffixes that are in an k-LCP interval with S[n - k]
// have a suffix match >= k
vi find_suffix_match(const ESA& esa, const int l, const lcp_tree& t)
{
	const int n = sz(esa.s);
	vi suffix_match(n);
	auto dfs = [&](auto&& self, const lcp_tree& t) -> vector<int> {
		vector<int> cur;
		if (t.lb == t.rb && t.lb > 0) {
			cur.emplace_back(t.lb);
			return cur;
		}
		const int k = t.lcp;
		for (const auto& c : t.children) {
			auto tmp = self(self, c);
			if (sz(tmp) > sz(cur))
				swap(cur, tmp);
			cur.insert(cur.end(), all(tmp));
		}
		if (k <= 0 or n - 1 - k < 0 or k >= l)
			return cur;
		const int suffix = esa.ISA[n - 1 - k];
		if (suffix == 0 or t.lb > suffix or suffix > t.rb)
			return cur;
		for (int x : cur)
			if (x != suffix)
				suffix_match[x] = k;
		cur.clear();
		cur.emplace_back(suffix);
		return cur;
	};
	dfs(dfs, t);
	return suffix_match;
}

int main()
{
	ios::sync_with_stdio(false), cin.tie(nullptr);
	int n, l;
	string s;
	cin >> n >> l >> s;
	s += '$', n++;

	ESA fwd = build_esa(s);

	auto t = lcp_interval_tree(fwd);
	vi per = periods(fwd, l, t);

	vi suffix_match = find_suffix_match(fwd, l, t);

	for (int i = 1; i < n; i++) {
		const int j = fwd.SA[i], len = n - 1 - j;
		if (len > 0 and len < l)
			per[j] = min(per[j], len - suffix_match[i]);
	}

	pii res { 0, 0 };
	for (int i = 1; i < n;) {
		int j = i + 1;
		while (j < n and fwd.LCP[j] >= l)
			j++;

		int cnt = j - i;

		if (int dist = suffix_match[j - 1] + l - 1; dist >= l)
			cnt += 1 + (dist - l) / per[fwd.SA[i]];
		res = max(res, pii { cnt, j - 1 });
		i = j;
	}

	s.pop_back();
	cout << s;
	int j = res.second;
	int len = per[fwd.SA[j]];
	for (int i = 0; i < l - 1; i++)
		cout << s[fwd.SA[j] + (suffix_match[j] + i) % len];
	cout << endl;
}
