#include <bits/stdc++.h>
using namespace std;
#define sz(x) (int)size(x)
#define all(x) (x).begin(), (x).end()
constexpr int inf = 1e9;

constexpr int MAX_CHAR = 256;
struct SuffixArray {
	int n;
	vector<int> SA, LCP;
	vector<vector<int>> P;

	SuffixArray(const string& s) : n(sz(s)), SA(n), LCP(n),
		P(__lg(2 * n - 1) + 1, vector<int>(n)) {
		P[0].assign(all(s));
		iota(all(SA), 0);
		sort(all(SA), [&](int a, int b) {return s[a] < s[b];});
		vector<int> x(n);
		for (int k = 1, c = 1; c < n; k++, c *= 2) {
			iota(all(x), n - c);
			for (int ptr = c; int i : SA) if (i >= c) x[ptr++] = i - c;

			vector<int> cnt(k == 1 ? MAX_CHAR : n);
			for (int i : P[k-1]) cnt[i]++;
			partial_sum(all(cnt), begin(cnt));
			for (int i : x | views::reverse) SA[--cnt[P[k-1][i]]] = i;

			auto p = [&](int i) {return i < n ? P[k-1][i] : -1;};
			for (int i = 1; i < n; i++) {
				int a = SA[i-1], b = SA[i];
				P[k][b] = P[k][a] + (p(a) != p(b) || p(a+c) != p(b+c));
		}}
		for (int i = 1; i < n; i++) LCP[i] = lcp(SA[i-1], SA[i]);
	}

	int lcp(int x, int y) {//x & y are text-indices, not SA-indices
		if (x == y) return n - x;
		int res = 0;
		for (int i = sz(P) - 1; i >= 0 && max(x, y) + res < n; i--) {
			if (P[i][x + res] == P[i][y + res]) res |= 1 << i;
		}
		return res;
	}
};

struct SegTree {
	using T = pair<int, int>;
	int n;
	vector<T> tree;
	static constexpr T E = {inf, 0}; // Neutral element for combine

	SegTree(vector<T>& a) : n(sz(a)), tree(2 * n) {
	//SegTree(int size, T val = E) : n(size), tree(2 * n, val) {
		copy(all(a), tree.begin() + n);
		for (int i = n - 1; i > 0; i--) { // remove for range update
			tree[i] = comb(tree[2 * i], tree[2 * i + 1]);
	}}

	T comb(T a, T b) {return min(a, b);} // modify this + neutral

	void update(int i, T val) {
		tree[i += n] = val; // apply update code
		while (i /= 2) tree[i] = comb(tree[2 * i], tree[2 * i + 1]);
	}

	T query(int l, int r) {
		T resL = E, resR = E;
		for (l += n, r += n; l < r; l /= 2, r /= 2) {
			if (l&1) resL = comb(resL, tree[l++]);
			if (r&1) resR = comb(tree[--r], resR);
		}
		return comb(resL, resR);
	}
};


vector<int> prefun(string s){
	vector<int> p(sz(s));
	for(int i = 1, j = 0; i < sz(s); i++){
		while(j > 0 && s[j] != s[i]) j = p[j-1];
		if(s[j] == s[i]) j++;
		p[i] = j;
	}
	return p;
}

int main(){
	int n, k;
	cin >> n >> k;
	string s;
	cin >> s;

	// new substrings
	int ans = 0, cpind = 0, cpper = 0, startInd = 0;
	{
		string t = s.substr(n-k, k);
		reverse(all(t));
		vector<int> p = prefun(t);
		for(int i = 1; i < k; i++){
			int per = i - p[i-1];
			int cnt = (i+per-1)/per;
			if(cnt > ans){
				ans = cnt;
				cpind = n-i;
				cpper = per;
				startInd = n-i;
			}
		}
	}
	// ==== already existing substrings ====
	SuffixArray sa(s);
	// 1. find count of all substrings
	// Note: the count is only correct for one of the occurences,
	//       but of course this doesn't matter!
	vector<int> cnt(n-k+1);
	for(int i = 0, j = 0; i < n; i++){
		j = max(i, j);
		while(j < n-1 && sa.LCP[j+1] >= k) j++;
		if(sa.SA[i] <= n-k) cnt[sa.SA[i]] = j-i+1;
	}
	// 2. solve the "sliding window period problem"
	// - work on cartesian tree of LCP array
	// - use some small-to-large tricks for speedup
	vector<int> per(n-k+1, k);
	vector<pair<int, int>> ini(n), ini2(n+1);
	for(int i = 0; i < n; i++) ini[i] = {sa.LCP[i], i};
	SegTree indSeg(ini);

	vector<set<int>> valsAtPos(n+1);
	for(int i = 0; i <= n; i++) ini2[i] = {inf, i};
	SegTree valSeg(ini2);
	auto add = [&](int i, int val){
		valsAtPos[i].insert(val);
		valSeg.update(i, {*valsAtPos[i].begin(), i});
	};
	auto rem = [&](int i, int val){
		valsAtPos[i].erase(val);
		if(valsAtPos[i].empty()) valSeg.update(i, {inf, i});
		else valSeg.update(i, {*valsAtPos[i].begin(), i});
	};

	auto rec = [&](auto&& self, int l, int r, set<int>& outInds) -> void
	{
		if(l == r) return;
		if(l+1 == r){
			int i = sa.SA[l];
			outInds.insert(i);
			if(i <= n-k){
				per[i] = min(per[i], valSeg.query(i+k, n+1).first-i);
			}
			return;
		}
		auto [val, spl] = indSeg.query(l+1, r);
		val = min(val, k);
		int l1 = l, r1 = spl, l2 = spl, r2 = r;
		// if(r1-l1 > r2-l2) swap(l1, l2), swap(r1, r2);
		set<int> s1, s2;
		self(self, l1, r1, s1);
		for(int x : s1) add(x+val, x);
		self(self, l2, r2, s2);
		for(int i : s1){
			auto it = s2.lower_bound(i+k-val);
			if(it != s2.end()) per[i] = min(per[i], *it-i);
		}
		for(int x : s1) rem(x+val, x), s2.insert(x);
		swap(outInds, s2);
	};
	set<int> saInds;
	rec(rec, 0, n, saInds);

	// 3. find longest part of suffix which matches prefix
	//    and calc answer
	{
		string t = s + "#" + s.substr(n-k+1);
		reverse(all(t));
		vector<int> p = prefun(t);
		for(int i = 0; i <= n-k; i++){
			int cn = cnt[i];
			int pe = per[i];
			int x = p.end()[-i-1];
			cn += (x+pe-1) / pe;
			if(cn > ans){
				ans = cn;
				cpind = i;
				cpper = pe;
				startInd = n-x;
			}
		}
	}

	cerr << ans << "\n";
	s.resize(n+k-1);
	for(int i = startInd; i < sz(s); i++){
		char c = s[cpind + (i-startInd)%cpper];
		if(i < n) assert(c == s[i]);
		s[i] = c;
	}
	cout << s << "\n";
}