#include "bits/stdc++.h"
using namespace std;
typedef long long ll;
typedef pair<int,int> pi;
typedef vector<int> vi;
#define all(x) begin(x),end(x)
vi kmp(string s) {
    int n = s.size();
    vector<int> p(n);
    for(int i=1,j=0;i<n;++i) {
        while(j>0 and s[i]!=s[j]) {
            j = p[j-1];
        }
        j+=s[i]==s[j];
        p[i]=j;
    }
    return p;
}
mt19937 rng(69); // can be made randomized with time.
int rnd(int l, int r) {
    return uniform_int_distribution(l,r)(rng);
}
const int MOD = 1e9+9;
typedef array<int,2> S;
S operator+(S a, S b) {return {(a[0]+b[0])%MOD,(a[1]+b[1])%MOD};}
S operator-(S a, S b) { return {(a[0]-b[0]+MOD)%MOD,(a[1]-b[1]+MOD)%MOD};}
S operator*(S a, S b) {return {((ll)a[0]*b[0])%MOD,((ll)a[1]*b[1])%MOD}; }
struct S_hash {
    uint64_t operator()(const S& s) const {
        return (s[0]*ll(MOD) + s[1]);
    }
};
struct H {
    vector<S> h;
    vector<S> pw;
    H(string s) {
        int n = s.size();
        pw.resize(n+1);
        h.resize(n+1);
        pw[0] = {1,1};
        S base = {rnd(1,MOD-1),rnd(1,MOD-1)};
        for(int i=1;i<=n;++i) pw[i] = pw[i-1]*base;
        for(int i=0;i<n;++i) {
            h[i+1] = h[i]*base + S{s[i],s[i]};
        }
    }
    S substr(int l, int r) { // [l,r)
        return h[r] - h[l]*pw[r-l];
    }
};
int main() {
    cin.tie(NULL)->sync_with_stdio(false);
    int n; cin >> n;
    int L; cin >> L;
    string s; cin >> s;
    reverse(all(s));
    auto p = kmp(s);
    H h(s);
    unordered_map<S,S,S_hash> mp;

    for(int i=0;i+L<=n;++i) {
        auto& o = mp[h.substr(i,i+L)];
        if(o[0]==0) o[1]=i;
        o[0]++;
    }
    vi smallp(n);
    for(int i=1;i<n;++i) {
        if(p[i]>L) {
            smallp[i] = smallp[p[i]];
        } else smallp[i] = p[i];
    }
    int ans=0;
    int ansperiod=-1;
    auto updateAns = [&](int mine, int period) {
        if(mine<=ans) return;
        ans=mine;
        ansperiod=period;
    };
    for(auto [k,v] : mp) {
        updateAns(v[0],1);
    }
    for(auto [k,v] : mp) { 
        int at = v[1];
        auto borderStart = smallp[at+L-1];
        if(borderStart==0) continue;
        updateAns(v[0]+1,at+L-borderStart);
        int cur = p[borderStart-1];
        while(cur>0) { // this loop could be linear, and so the total algorithm could be O(n^2 log(n)).
            int period = borderStart-cur;
            S want = {};
            int len=0;
            { // binary exponentation!
            // with some more work can be made O(1).
                int num = L/period;
                S A = h.substr(borderStart-period,borderStart);
                int Alen = period;
                while(num>0) {
                    if(num&1) want = A*h.pw[len] + want, len+=Alen;

                    A = A + A*h.pw[Alen];
                    Alen*=2;
                    num/=2;
                }
            }   
            want = h.substr(borderStart-(L-len),borderStart)*h.pw[len] + want;
            if(want==k) {
                updateAns(v[0] + 1 + (borderStart-1)/period,period);
                break;
            }
            cur=p[cur-1];
        }
    }
    for(int borderStart=1;borderStart<L;++borderStart) {
        int cur = p[borderStart-1];
        int period = borderStart-cur;
        if(cur>0) updateAns((1 + (borderStart-1)/period),period);
    }
    reverse(all(s));
    for(int i=0;i<L-1;++i) {
        s.push_back(s[s.size()-ansperiod]);
    }
    cerr << ans << '\n';
    cout << s << '\n';


}