import sys
sys.setrecursionlimit(1000000)

def eprint(*args, **kwargs):
    print(*args, file=sys.stderr, **kwargs)

def sais(S, sa, n):
    C = [0] * max(n, 256)
    for i in range(n):
        sa[i] = 0

    def Ccnt():
        for i in range(len(C)):
            C[i] = 0
        for i in range(n):
            C[S[i]] += 1
    def Cend():
        Ccnt()
        for i in range(1, len(C)):
            C[i] += C[i - 1]

    type = [True] * n
    isLMS = [False] * n
    for i in reversed(range(0, n - 1)):
        type[i] = S[i] < S[i + 1] + type[i + 1]
    for i in range(1, n):
        isLMS[i] = type[i] and not type[i - 1]

    def induceLS():
        Ccnt()
        s = 0
        for i in range(len(C)):
            s += C[i]
            C[i] = s - C[i]

        for i in range(n):
            pre = sa[i] - 1
            if pre >= 0 and not type[pre]:
                sa[C[S[pre]]] = pre
                C[S[pre]] += 1

        Cend()
        for i in reversed(range(n)):
            pre = sa[i] - 1
            if (pre >= 0 and type[pre]):
                C[S[pre]] -= 1
                sa[C[S[pre]]] = pre

    Cend()
    for i in range(1, n):
        if isLMS[i]:
            C[S[i]] -= 1
            sa[C[S[i]]] = i
    induceLS()
    m = 0
    for i in range(n):
        if isLMS[sa[i]]:
            sa[m] = sa[i]
            m += 1
    sa[m + sa[0] // 2] = 0
    name = 1
    for i in range(1, m):
        l = 0
        a = sa[i - 1]
        b = sa[i]
        while S[a + l] == S[b + l] and isLMS[a + l] == isLMS[b + l]:
            if l > 0 and isLMS[a + l]:
                name -= 1
                break
            l += 1
        sa[m + b // 2] = name
        name += 1
    Cend()
    if m > name:
        newS = [0] * m
        newSA = [0] * m
        k = 0
        for i in range(n):
            if isLMS[i]:
                newS[k] = sa[m + i // 2]
                k += 1
        sais(newS, newSA, m)
        k = 0
        for i in range(n):
            if isLMS[i]:
                sa[k] = i
                k += 1
                C[S[i]] -= 1
        for i in range(m):
            sa[i + n - m] = sa[newSA[i]]
    else:
        for i in range(m):
            sa[i + n - m] = sa[i]
            C[S[sa[i]]] -= 1

    for i in range(n - m):
        sa[i] = 0
    for i in range(m):
        lms = sa[i + n - m]
        sa[i + n - m] = 0
        sa[C[S[lms]]] = lms
        C[S[lms]] += 1
    induceLS()

def kasai(S, SA, ISA, n):
    LCP = [-1] * (n + 1)
    lcp = 0
    for i in range(n - 1):
        while S[i + lcp] == S[SA[ISA[i] - 1] + lcp]:
            lcp += 1
        LCP[ISA[i]] = lcp
        lcp = max(lcp - 1, 0)
    return LCP

class ESA():
    def __init__(self, s):
        self.S = [ ord(c) for c in s ]
        n = len(self.S)
        self.SA = [0] * n
        sais(self.S, self.SA, n)
        self.ISA = [0] * n
        for i in range(n):
            self.ISA[self.SA[i]] = i
        self.LCP = kasai(self.S, self.SA, self.ISA, n)

class LCPTree():
    def __init__(self, l, b, r):
        self.lcp = l
        self.lb = b
        self.rb = r
        self.children = []
def lcp_interval_tree(esa):
    n = len(esa.S)
    st = []
    st.append(LCPTree(-1, 0, n))
    for i in range(1, n + 1):
        st.append(LCPTree(n, i - 1, n))
        lcp = esa.LCP[i]
        lb = i - 1
        last = None
        while lcp < st[-1].lcp:
            st[-1].rb = i - 1
            last = st.pop()
            lb = last.lb
            if lcp <= st[-1].lcp:
                st[-1].children.append(last)
                last = None
        if lcp > st[-1].lcp:
            st.append(LCPTree(lcp, lb, n))
            if last is not None:
                st[-1].children.append(last)
    return st[-1]

class LST():
    def __init__(self, n):
        self.n = n
        self.sz = 0
        self.nodes = []
    class Node():
        def __init__(self):
            self.l = -1
            self.r = -1
            self.m = 1000000000
            self.max_i = -1
    def elems(self):
        res = []
        def dfs(ni, i, s):
            node = self.nodes[ni]
            if s == 1:
                res.append((i, node.m))
                return
            sl = s // 2
            sr = s - sl
            if node.l != -1:
                self.nodes[node.l].m = min(self.nodes[node.l].m, node.m)
                dfs(node.l, i, sl)
            if node.r != -1:
                self.nodes[node.r].m = min(self.nodes[node.r].m, node.m)
                dfs(node.r, i + sl, sr)
        if len(self.nodes) > 0:
            dfs(0, 0, self.n)
        return res
    def insert(self, i, m):
        self.sz += 1
        s = self.n
        ni = 0
        while (s > 1):
            if ni == len(self.nodes):
                self.nodes.append(self.Node())
            node = self.nodes[ni]
            node.max_i = max(node.max_i, i)
            if node.l != -1:
                self.nodes[node.l].m = min(self.nodes[node.l].m, node.m)
            if node.r != -1:
                self.nodes[node.r].m = min(self.nodes[node.r].m, node.m)
            node.m = 1000000000
            sl = s // 2
            if i < sl:
                if node.l == -1:
                    node.l = len(self.nodes)
                ni = node.l
                s = sl
            else:
                i -= sl
                s -= sl
                if node.r == -1:
                    node.r = len(self.nodes)
                ni = node.r
        node = self.Node()
        node.m = m
        node.max_i = i
        self.nodes.append(node)
    def update_min(self, i, v):
        def dfs(ni, i, s):
            node = self.nodes[ni]
            if s == 1:
                node.m = min(node.m, v)
                return
            sl = s // 2
            if i < sl:
                if node.l != -1:
                    dfs(node.l, i, sl)
            else:
                if node.l != -1:
                    self.nodes[node.l].m = min(self.nodes[node.l].m, v)
                if node.r != -1 and i - sl > 0:
                    dfs(node.r, i - sl, s - sl)
        if i > 0 and len(self.nodes) > 1:
            dfs(0, i, self.n)
    def lower_bound(self, i):
        if len(self.nodes) == 0 or self.nodes[0].max_i < i:
            return None
        ni = 0
        s = self.n
        acc = 0
        while s > 1:
            sl = s // 2
            node = self.nodes[ni]
            if node.l != -1 and self.nodes[node.l].max_i >= i:
                s = sl
                ni = node.l
            else:
                s -= sl
                i -= sl
                ni = node.r
                acc += sl
        return acc

def periods(esa, l, t):
    per = [l] * len(esa.S)
    def dfs(t):
        cur = LST(len(esa.S))
        if t.lb == t.rb:
            cur.insert(esa.SA[t.lb], esa.SA[t.lb] + l)
            return cur
        for c in t.children:
            tmp = dfs(c)
            if cur.sz < tmp.sz:
                cur, tmp = tmp, cur
            for (i,curm) in tmp.elems():
                it = cur.lower_bound(max(i + 1, i + l - t.lcp))
                if it is not None:
                    per[i] = min(per[i], it - i)
                cur.update_min(min(i - 1, i - l + t.lcp) + 1, i)
                cur.insert(i, curm)
        return cur
    for (i,j) in dfs(t).elems():
        per[i] = min(per[i], max(1, j - i))
    return per

def find_suffix_match(esa, l, t):
    n = len(esa.S)
    suffix_match = [0] * n
    def dfs(t):
        cur = []
        if t.lb == t.rb and t.lb > 0:
            cur.append(t.lb)
            return cur
        k = t.lcp
        for c in t.children:
            tmp = dfs(c)
            if len(tmp) > len(cur):
                tmp, cur = cur, tmp
            for x in tmp:
                cur.append(x)
        if k <= 0 or n - 1 - k < 0 or k >= l:
            return cur
        suffix = esa.ISA[n - 1 - k]
        if suffix == 0 or t.lb > suffix or suffix > t.rb:
            return cur
        for x in cur:
            if x != suffix:
                suffix_match[x] = k
        return [suffix]
    dfs(t)
    return suffix_match
 

[n, l] = [int(x) for x in input().split()]
s = input()
s += '$'
n += 1
fwd = ESA(s)
eprint("fwd")
t = lcp_interval_tree(fwd)
eprint("t")
per = periods(fwd, l, t)
eprint("per")
suffix_match = find_suffix_match(fwd, l, t)
eprint("suffix_match")
for i in range(1, n):
    j = fwd.SA[i]
    len = n - 1 - j
    if len > 0 and len < l:
        per[j] = min(per[j], len - suffix_match[i])
res = (0, 0)
for i in range(1, n):
    j = i + 1
    while j < n and fwd.LCP[j] >= l:
        j += 1
    cnt = j - i
    dist = suffix_match[j - 1] + l - 1
    if dist >= l:
        cnt += 1 + (dist - l) // per[fwd.SA[i]]
    res = max(res, (cnt, i))
    i = j

fwd.S.pop()
(_, j) = res
len = per[fwd.SA[j]]
for i in range(l - 1):
    fwd.S.append(fwd.S[fwd.SA[j] + (suffix_match[j] + i) % len])
print(''.join([chr(x) for x in fwd.S]))

