import java.io.*;
import java.util.*;
import java.util.function.*;

public class jannik {
  static void Ccnt(int[] C, int[] S, int n) {
    for (int i = 0; i < C.length; i++)
      C[i] = 0;
    for (int i = 0; i < n; i++)
      C[S[i]]++;
  }

  static void Cend(int[] C, int[] S, int n) {
    Ccnt(C, S, n);
    for (int i = 1; i < C.length; i++)
      C[i] += C[i - 1];
  }

  static void induceLS(int[] C, int[] S, int[] sa, boolean[] type, int n) {
    Ccnt(C, S, n);
    for (int i = 0, s = 0; i < C.length; i++) {
      s += C[i];
      C[i] = s - C[i];
    }

    for (int i = 0; i < n; i++) {
      int pre = sa[i] - 1;
      if (pre >= 0 && !type[pre])
        sa[C[S[pre]]++] = pre;
    }

    Cend(C, S, n);
    for (int i = n; i-- > 0;) {
      int pre = sa[i] - 1;
      if (pre >= 0 && type[pre])
        sa[--C[S[pre]]] = pre;
    }
  }

  static void sais(int[] S, int[] sa, int n) {
    int[] C = new int[Math.max(n, 256)];
    for (int i = 0; i < n; i++)
      sa[i] = 0;
    boolean[] type = new boolean[n], isLMS = new boolean[n];
    type[n - 1] = true;
    for (int i = n - 1; i-- > 0;)
      type[i] = S[i] < S[i + 1] + (type[i + 1] ? 1 : 0);
    for (int i = 1; i < n; i++)
      isLMS[i] = type[i] && !type[i - 1];

    Cend(C, S, n);
    for (int i = 1; i < n; i++)
      if (isLMS[i])
        sa[--C[S[i]]] = i;

    induceLS(C, S, sa, type, n);
    int m = 0;
    for (int i = 0; i < n; i++)
      if (isLMS[sa[i]])
        sa[m++] = sa[i];
    sa[m + sa[0] / 2] = 0;
    int name = 1;
    for (int i = 1; i < m; i++, name++) {
      int l = 0, a = sa[i - 1], b = sa[i];
      for (; S[a + l] == S[b + l] && isLMS[a + l] == isLMS[b + l]; l++)
        if (l > 0 && isLMS[a + l]) {
          name--;
          break;
        }
      sa[m + b / 2] = name;
    }
    Cend(C, S, n);
    if (m > name) {
      int[] newS = new int[m];
      int[] newSA = new int[m];
      for (int k = 0, i = 0; i < n; i++)
        if (isLMS[i])
          newS[k++] = sa[m + i / 2];
      sais(newS, newSA, m);
      for (int i = 0, k = 0; i < n; i++)
        if (isLMS[i]) {
          sa[k++] = i;
          C[S[i]]--;
        }
      for (int i = 0; i < m; i++)
        sa[i + n - m] = sa[newSA[i]];
    } else {
      for (int i = 0; i < m; i++) {
        sa[i + n - m] = sa[i];
        C[S[sa[i]]]--;
      }
    }
    for (int i = 0; i < n - m; i++)
      sa[i] = 0;
    for (int i = 0; i < m; i++) {
      int lms = sa[i + n - m];
      sa[i + n - m] = 0;
      sa[C[S[lms]]++] = lms;
    }
    induceLS(C, S, sa, type, n);
  }

  static int[] kasai(int[] S, int[] SA, int[] ISA, int n) {
    int[] LCP = new int[n + 1];
    LCP[0] = LCP[n] = -1;
    for (int i = 0, lcp = 0; i < n - 1; i++) {
      while (S[i + lcp] == S[SA[ISA[i] - 1] + lcp])
        lcp++;
      LCP[ISA[i]] = lcp;
      lcp = Math.max(lcp - 1, 0);
    }
    return LCP;
  }

  static class ESA {
    public String s;
    public int[] SA, ISA, LCP;
  }

  static ESA build_esa(String s) {
    assert s.charAt(s.length() - 1) == '$';
    ESA res = new ESA();
    res.s = s;
    res.ISA = new int[s.length()];
    res.SA = new int[s.length()];
    int[] S = new int[s.length()];
    for (int i = 0; i < S.length; i++)
      S[i] = s.charAt(i);
    sais(S, res.SA, S.length);
    for (int i = 0; i < S.length; i++)
      res.ISA[res.SA[i]] = i;
    res.LCP = kasai(S, res.SA, res.ISA, S.length);
    return res;
  }

  static class LCPTree {
    int lcp, lb, rb;
    ArrayList<LCPTree> children;

    LCPTree(int l, int b, int r) {
      lcp = l;
      lb = b;
      rb = r;
      children = new ArrayList<>();
    }
  }

  static LCPTree lcp_interval_tree(ESA esa) {
    int n = esa.s.length();
    Stack<LCPTree> st = new Stack<>();
    st.add(new LCPTree(-1, 0, n));
    for (int i = 1; i <= n; i++) {
      st.add(new LCPTree(n, i - 1, n));
      int lcp = esa.LCP[i];
      int lb = i - 1;
      LCPTree last = null;
      while (lcp < st.peek().lcp) {
        st.peek().rb = i - 1;
        last = st.pop();
        lb = last.lb;
        if (lcp <= st.peek().lcp) {
          st.peek().children.add(last);
          last = null;
        }
      }
      if (lcp > st.peek().lcp) {
        st.add(new LCPTree(lcp, lb, n));
        if (last != null)
          st.peek().children.add(last);
      }
    }
    return st.peek();
  }

  static class lst {
    static class Node {
      public int l = -1, r = -1, m = 1000000000, max_i = -1;
    }

    public int n = 0, sz = 0;

    public int size() {
      return sz;
    }

    ArrayList<Node> nodes = new ArrayList<>();

    void for_each_dfs(BiConsumer<Integer, Integer> f, int ni, int i, int s) {
      Node node = nodes.get(ni);
      if (s == 1) {
        f.accept(i, node.m);
        return;
      }
      int sl = s / 2, sr = s - sl;
      int l = node.l;
      if (l != -1) {
        nodes.get(l).m = Math.min(nodes.get(l).m, node.m);
        for_each_dfs(f, l, i, sl);
      }
      int r = node.r;
      if (r != -1) {
        nodes.get(r).m = Math.min(nodes.get(r).m, node.m);
        for_each_dfs(f, r, i + sl, sr);
      }
    }

    void for_each(BiConsumer<Integer, Integer> f) {
      if (!nodes.isEmpty())
        for_each_dfs(f, 0, 0, n);

    }

    void insert(int i, int m) {
      sz++;
      int s = n, ni = 0;
      while (s > 1) {
        if (ni == nodes.size())
          nodes.add(new Node());
        Node node = nodes.get(ni);
        node.max_i = Math.max(node.max_i, i);
        if (node.l != -1)
          nodes.get(node.l).m = Math.min(nodes.get(node.l).m, node.m);
        if (node.r != -1)
          nodes.get(node.r).m = Math.min(nodes.get(node.r).m, node.m);
        int sl = s / 2;
        node.m = 1000000000;
        if (i < sl) {
          if (node.l == -1)
            node.l = nodes.size();
          ni = node.l;
          s = sl;
        } else {
          i -= sl;
          s -= sl;
          if (node.r == -1)
            node.r = nodes.size();
          ni = node.r;
        }
      }
      Node node = new Node();
      node.m = m;
      node.max_i = i;
      nodes.add(node);
    }

    void update_min_dfs(int v, int ni, int i, int s) {
      Node node = nodes.get(ni);
      if (s == 1) {
        node.m = Math.min(node.m, v);
        return;
      }
      int sl = s / 2;
      if (i < sl) {
        if (node.l != -1)
          update_min_dfs(v, node.l, i, sl);
      } else {
        if (node.l != -1)
          nodes.get(node.l).m = Math.min(nodes.get(node.l).m, v);
        if (node.r != -1 && i - sl > 0)
          update_min_dfs(v, node.r, i - sl, s - sl);
      }
    }

    void update_min(int i, int v) {
      if (i > 0 && !nodes.isEmpty())
        update_min_dfs(v, 0, i, n);
    }

    Integer lower_bound(int i) {
      if (nodes.isEmpty() || nodes.get(0).max_i < i)
        return null;
      int ni = 0, s = n, acc = 0;
      while (s > 1) {
        int sl = s / 2;
        Node node = nodes.get(ni);
        if (node.l != -1 && nodes.get(node.l).max_i >= i) {
          s = sl;
          ni = node.l;
        } else {
          s -= sl;
          i -= sl;
          ni = node.r;
          acc += sl;
        }
      }
      return acc;
    }
  }

  static lst periods_dfs(ESA esa, int[] per, LCPTree t, int l) {
    lst cur = new lst();
    cur.n = per.length;
    if (t.lb == t.rb) {
      cur.insert(esa.SA[t.lb], esa.SA[t.lb] + l);
      return cur;
    }
    for (LCPTree c : t.children) {
      lst tmp = periods_dfs(esa, per, c, l);
      if (cur.size() < tmp.size()) {
        lst a = tmp;
        tmp = cur;
        cur = a;
      }
      final lst bla = cur; // why is Java?
      tmp.for_each((i, curm) -> {
        Integer it = bla.lower_bound(Math.max(i + 1, i + l - t.lcp));
        if (it != null)
          per[i] = Math.min(per[i], it - i);
        bla.update_min(Math.min(i - 1, i - l + t.lcp) + 1, i);
        bla.insert(i, curm);
      });
    }

    return cur;
  }

  static int[] periods(ESA esa, int l, LCPTree t) {
    int[] per = new int[esa.s.length()];
    for (int i = 0; i < per.length; i++)
      per[i] = l;
    periods_dfs(esa, per, t, l).for_each((i, j) -> per[i] = Math.min(per[i], Math.max(1, j - i)));
    return per;
  }

  static ArrayList<Integer> find_suffix_match_dfs(ESA esa, int l, int[] suffix_match, LCPTree t) {
    ArrayList<Integer> cur = new ArrayList<>();
    if (t.lb == t.rb && t.lb > 0) {
      cur.add(t.lb);
      return cur;
    }
    int k = t.lcp;
    int n = suffix_match.length;
    for (LCPTree c : t.children) {
      ArrayList<Integer> tmp = find_suffix_match_dfs(esa, l, suffix_match, c);
      if (tmp.size() > cur.size()) {
        tmp.addAll(cur);
        cur = tmp;
      } else
        cur.addAll(tmp);
    }
    if (k <= 0 || n - 1 - k < 0 || k >= l)
      return cur;
    int suffix = esa.ISA[n - 1 - k];
    if (suffix == 0 || t.lb > suffix || suffix > t.rb)
      return cur;
    for (int x : cur)
      if (x != suffix)
        suffix_match[x] = k;
    cur.clear();
    cur.add(suffix);
    return cur;
  }

  static int[] find_suffix_match(ESA esa, int l, LCPTree t) {
    int n = esa.s.length();
    int[] suffix_match = new int[n];
    find_suffix_match_dfs(esa, l, suffix_match, t);
    return suffix_match;
  }

  public static void main(String[] args) throws IOException {
    BufferedReader rd = new BufferedReader(new InputStreamReader(System.in));
    String[] line = rd.readLine().split(" ");
    int n = Integer.parseInt(line[0]);
    int l = Integer.parseInt(line[1]);
    String s = rd.readLine().split(" ")[0];
    n++;
    s += '$';

    ESA fwd = build_esa(s);

    LCPTree t = lcp_interval_tree(fwd);
    int[] per = periods(fwd, l, t);

    int[] suffix_match = find_suffix_match(fwd, l, t);

    for (int i = 1; i < n; i++) {
      int j = fwd.SA[i], len = n - 1 - j;
      if (len > 0 && len < l)
        per[j] = Math.min(per[j], len - suffix_match[i]);
    }

    int res_c = -1, res_i = 0;
    for (int i = 1; i < n;) {
      int j = i + 1;
      while (j < n && fwd.LCP[j] >= l)
        j++;

      int cnt = j - i;
      int dist = suffix_match[j - 1] + l - 1;
      if (dist >= l)
        cnt += 1 + (dist - l) / per[fwd.SA[i]];
      if (cnt > res_c) {
        res_c = cnt;
        res_i = i;
      }

      i = j;
    }

    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < n - 1; i++)
      sb.append(s.charAt(i));
    int len = per[fwd.SA[res_i]];
    for (int i = 0; i < l - 1; i++)
      sb.append(s.charAt(fwd.SA[res_i] + (suffix_match[res_i] + i) % len));
    System.out.println(sb.toString());
  }
}
