{-# LANGUAGE Strict, ScopedTypeVariables, TupleSections, FlexibleContexts #-}

import Control.Monad
import Control.Monad.ST
import Data.Array.ST
import Data.Array.MArray
import Data.Array.Unboxed
import Data.List
import Data.Foldable
import Control.Monad.State.Strict
import qualified Data.IntSet as S

type S = UArray Int Int
type SA = UArray Int Int
type ISA = UArray Int Int
type LCP = UArray Int Int

sais :: S -> SA
sais s' = runSTUArray $ do
  let (0,n) = bounds s'
      si i = s' ! i
      s = elems s'
      sigma = maximum s
  sa <- newArray (0,n) 0
  let ccnt :: UArray Int Int = accumArray (+) 0 (0, sigma) ((,1) <$> s)
      typ, isLMS :: UArray Int Bool
      typ = listArray (0, n) $ scanr (\(l,r) b -> l < r + fromEnum b) True (zip s (tail s))
      isLMS = listArray (0, n) $ False : zipWith (&&) (tail $ elems typ) (map not $ elems typ)
      lmsIndices = filter (isLMS!) [0..n]
  c <- newArray (0, sigma) 0 :: ST s (STUArray s Int Int)
  let cend = zipWithM_ (writeArray c) [0..sigma] (scanl1 (+) (elems ccnt))
      cstart = zipWithM_ (writeArray c) [0..sigma] (scanl (+) 0 (elems ccnt))
      cinc i = readArray c i >>= \c' -> c' <$ writeArray c i (c' + 1)
      cdec i = readArray c i >>= (\c' -> c' <$ writeArray c i c') . pred
      induceLS = do
        cstart
        forM_ [0..n] $ \i -> do
          pre <- pred <$> readArray sa i
          when (pre >= 0 && not (typ!pre)) $ cinc (si pre) >>= \c' -> writeArray sa c' pre
        cend
        forM_ [n,n-1..0] $ \i -> do
          pre <- pred <$> readArray sa i
          when (pre >= 0 && typ!pre) $ cdec (si pre) >>= \c' -> writeArray sa c' pre
  cend
  forM_ lmsIndices $ \i -> cdec (si i) >>= \c' -> writeArray sa c' i
  induceLS
  lmsorder <- filter (isLMS!) <$> mapM (readArray sa) [0..n]
  zipWithM_ (writeArray sa) [0..] lmsorder
  let m = length lmsorder
      lmssubstr i = si <$> i : (i + 1) : takeWhile (not . (isLMS!) . pred) [i+2..n]
      lmssubstrings = lmssubstr <$> lmsorder
      diffs = zipWith (/=) lmssubstrings (tail lmssubstrings)
      names = scanl (+) 0 (fromEnum <$> diffs)
      name = 1 + last names
  zipWithM_ (\i -> writeArray sa (m + quot i 2)) lmsorder names
  if m > name
  then do
    tmpS <- listArray (0,m-1) <$> mapM (\i -> readArray sa (m + quot i 2)) lmsIndices
    let tmpSA = sais tmpS
    zipWithM_ (writeArray sa) [0..m-1] lmsIndices
    forM_ (assocs tmpSA) $ \(i,a) -> readArray sa a >>= writeArray sa (i + n + 1 - m)
  else zipWithM_ (writeArray sa) [n + 1 - m..n] lmsorder
  cend
  forM_ lmsIndices $ cdec . si
  forM_ [0..n-m] $ \i -> writeArray sa i 0

  forM_ [0..m-1] $ \i -> do
    lms <- readArray sa (i + n + 1 - m)
    writeArray sa (i + n + 1 - m) 0
    c' <- cinc (si lms)
    writeArray sa c' lms
  induceLS
  return sa

kasai :: S -> SA -> ISA -> LCP
kasai s sa isa = array (0, n+1) $ [(0,-1),(n+1,-1)] ++ snd (mapAccumL f 0 (init $ indices s))
  where
    (0,n) = bounds s
    f lcp i = (max (pred lcp') 0, (isa!i, lcp'))
      where
        lcp' = lcp + length (takeWhile id $ zipWith (\a b -> s!a==s!b) [i+lcp..] [sa!((isa!i) - 1)+lcp..])

invert :: UArray Int Int -> UArray Int Int
invert a = array (bounds a) [ (v,i) | (i,v) <- assocs a ]

data ESA
  = ESA
  { s :: S
  , sa :: SA
  , isa :: ISA
  , lcp :: LCP
  }
buildESA :: String -> ESA
buildESA s' = ESA s sa isa (kasai s sa isa)
  where
    s = listArray (0, length s' - 1) $ fromEnum <$> s'
    sa = sais s
    isa = invert sa

data LCPTree
  = Node Int [LCPTree]
  | Leaf Int
  deriving (Show)
llcp (Node l _) = l
llcp _ = 10^9
lcpTree :: ESA -> LCPTree
lcpTree esa = (\[r] -> r) $ execState (zipWithM_ go (elems $ sa esa) (tail $ elems $ lcp esa)) [Node (-1) []]
  where
    (0,n) = bounds $ lcp esa
    pop = modify' tail
    push s = modify' (s:)
    peek :: State [LCPTree] LCPTree
    peek = (\(x:_) -> x) <$> get
    addToTop c = modify' (\(h:hs) -> (case h of Node l ch -> Node l (c:ch)) : hs)
    go i lcp = do
      let step last = peek >>= \n -> if lcp < llcp n
            then do
              let last' = n
              pop
              peek >>= \n -> if lcp <= llcp n then addToTop last' >> step Nothing else step (Just last')
            else peek >>= \n -> when (lcp > llcp n) $ do
              push (Node lcp [])
              for_ last addToTop
      push $ Leaf i
      step Nothing

data LSTN
  = LSTN LSTN LSTN Int Int -- l r m maxI
  | LLeaf Int Int -- m maxI
  deriving (Show)
data LST = LST Int Int LSTN -- n sz r
inf :: Int = 10^9
empty :: Int -> LST
empty n = let n' = head $ dropWhile (<n) $ iterate (*2) 1 in LST n' 0 (go n')
  where
    go 1 = LLeaf inf (-1)
    go n = let x = go (quot n 2) in LSTN x x inf (-1)
size (LST _ s _) = s
lstElems :: LST -> [(Int,Int)]
lstElems (LST n _ r) = go [] 0 inf n r
  where
    go acc i m' 1 (LLeaf m mI) = if mI /= -1 then (i, min m m') : acc else acc
    go acc i m' n (LSTN l r m mI)
      | mI == -1 = acc --empty
      | otherwise = go (go acc (i + sl) m'' (n - sl) r) i m'' sl l
      where
        m'' = min m m'
        sl = quot n 2
pushM :: Int -> LSTN -> LSTN
pushM m' (LSTN l r m mI) = LSTN l r (min m m') mI
pushM m' (LLeaf m mI) = LLeaf (min m m') mI
lstInsert :: Int -> Int -> LST -> LST
lstInsert i im (LST n sz r) = LST n (sz + 1) (go inf i n r)
  where
    go mm i 1 (LLeaf m mI) = LLeaf im 0
    go mm i n (LSTN l r m mI)
      | i < sl = LSTN (go m' i sl l) (pushM m' r) inf (max mI i)
      | otherwise = LSTN (pushM m' l) (go m' (i - sl) (n - sl) r) inf (max mI i)
      where
        m' = min mm m
        sl = quot n 2
lstUpdateMin :: Int -> Int -> LST -> LST
lstUpdateMin i v (LST n sz r)
  | i > 0 = LST n sz (go i n r)
  | otherwise = LST n sz r
  where
    go i 1 (LLeaf m mI) = LLeaf (min m v) mI
    go i n (LSTN l r m mI)
      | i < sl = LSTN (go i sl l) r m mI
      | otherwise = LSTN
          (pushM (min m v) l)
          (if i - sl > 0 then go (i - sl) (n - sl) r else r)
          m mI
      where
        sl = quot n 2
lowerBound :: Int -> LST -> Maybe Int
lowerBound i (LST n sz r@(LSTN _ _ _ mI)) | mI >= i && mI /= -1 = Just $ go i n r
  where
    go _ 1 _ = 0
    go i n (LSTN l@(LLeaf _ mI) r _ _) | mI >= i && mI /= -1 = 0
    go i n (LSTN l@(LSTN _ _ _ mI) r _ _) | mI >= i && mI /= -1 = go i (quot n 2) l
    go i n (LSTN _ r _ _) = let sl = quot n 2 in sl + go (i - sl) (n - sl) r
lowerBound _ _ = Nothing

periods :: LCPTree -> ESA -> Int -> UArray Int Int
periods lcpT esa l = accumArray min l (bounds $ s esa) $ execState (dfs lcpT >>= mapM_ (\(i,j) -> modify' ((i, max 1 $ j - i):)) . lstElems) []
  where
    check lcp j i = modify' ((i, j - i):)
    emptyT = empty (succ $ snd $ bounds $ s esa)
    dfs :: LCPTree -> State [(Int,Int)] LST
    dfs (Leaf i) = return $ lstInsert i (i + l) emptyT
    dfs (Node lcp ch) = mapM dfs ch >>= \xs ->
      go lcp emptyT xs 
    go :: Int -> LST -> [LST] -> State [(Int,Int)] LST
    go lcp cur [] = return cur
    go lcp cur' (tmp':cs) = do
      let (tmp, cur) = if size tmp' < size cur' then (tmp',cur') else (cur',tmp')
      cur' <- foldM (\cur (i, curm) -> do
          for_ (lowerBound (max (i + 1) (i + l - lcp)) cur) (flip (check lcp) i)
          pure $ lstInsert i curm $ lstUpdateMin (1 + min (i - 1) (i - l + lcp)) i cur
        ) cur (lstElems tmp)
      go lcp cur' cs

findSuffixMatch :: LCPTree -> ESA -> Int -> UArray Int Int
findSuffixMatch lcpT esa l = array (bounds $ s esa) $ execState (dfs lcpT) [(0,0)]
  where
    (0, n) = bounds $ s esa
    dfs (Leaf j) = let i = isa esa ! j in return $ if i > 0 then S.singleton i else S.empty
    dfs (Node lcp ch) = mapM dfs ch >>= go lcp . S.unions
    go lcp cur | lcp <= 0 || n - lcp < 0 || lcp >= l = return cur
    go lcp cur
      | suffix == 0 || not (S.member suffix cur) = return cur
      | otherwise = S.singleton suffix <$ modify' ([ (i,lcp) | i <- S.elems cur, i /= suffix ]++)
      where
        suffix = isa esa ! (n - lcp)

main = interact $ solve . words

solve [n',l',s''] = sol
  where
    n = 1 + read n'
    l = read l'
    s' = s'' ++ ['$']
    esa = buildESA s'
    lcpT = lcpTree esa
    per' = periods lcpT esa l
    suffixMatch = findSuffixMatch lcpT esa l
    per = per' //
      [ (j, min (per' ! j) (len - sm))
      | (sm, j) <- tail $ zip (elems suffixMatch) (elems $ sa esa)
      , let len = n - 1 - j
      , len > 0, len < l
      ]
    go i j
      | i >= n = []
      | j < n && lcp esa ! j >= l = go i (j + 1)
    go i j = (cnt, j - 1) : go j (j + 1)
      where
        dist = suffixMatch ! (j - 1) + l - 1
        cnt
          | dist >= l = j - i + 1 + quot (dist - l) (per ! (sa esa ! i))
          | otherwise = j - i
    j = snd $ maximum $ go 0 1
    j' = sa esa ! j
    len = per ! j'
    sol = init s' ++ (toEnum <$> [ s esa ! (j' + rem (suffixMatch ! j + i) len) | i <- [0..l-2]])
