#include <algorithm>
#include <cassert>
#include <cstdint>
#include <iostream>
#include <numeric>
#include <optional>
#include <stack>
#include <vector>

using namespace std;
#define sz(a) ((int)((a).size()))
#define all(a) (a).begin(), (a).end()
using vi = vector<int>;
using pii = pair<int, int>;
using u64 = uint64_t;

void sais(const auto* S, int* sa, const int n)
{
	vi C(max(n, 256));
	fill_n(sa, n, 0);

	const auto Ccnt = [&] {
		fill(all(C), 0);
		for (int i = 0; i < n; i++)
			C[S[i]]++;
	};
	const auto Cend = [&] {
		Ccnt();
		partial_sum(all(C), C.begin());
	};

	vector<bool> type(n, true), isLMS(n);
	for (int i = n - 1; i-- > 0;)
		type[i] = S[i] < S[i + 1] + type[i + 1];
	for (int i = 1; i < n; i++)
		isLMS[i] = type[i] and not type[i - 1];

	const auto induceLS = [&] {
		Ccnt();
		exclusive_scan(all(C), C.begin(), 0);

		for (int i = 0; i < n; i++)
			if (int pre = sa[i] - 1; pre >= 0 and not type[pre])
				sa[C[S[pre]]++] = pre;

		Cend();
		for (int i = n; i-- > 0;)
			if (int pre = sa[i] - 1; pre >= 0 and type[pre])
				sa[--C[S[pre]]] = pre;
	};

	Cend();
	for (int i = 1; i < n; i++)
		if (isLMS[i])
			sa[--C[S[i]]] = i;

	induceLS();
	int m = 0;
	for (int i = 0; i < n; i++)
		if (isLMS[sa[i]])
			sa[m++] = sa[i];
	sa[m + sa[0] / 2] = 0;
	int name = 1;
	for (int i = 1; i < m; i++, name++) {
		int l = 0, a = sa[i - 1], b = sa[i];
		for (; S[a + l] == S[b + l] and isLMS[a + l] == isLMS[b + l]; l++)
			if (l > 0 && isLMS[a + l]) {
				name--;
				break;
			}
		sa[m + b / 2] = name;
	}
	Cend();
	if (m > name) {
		for (int k = 0, i = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = sa[m + i / 2];
		sais(sa, sa + n - m, m);
		for (int i = 0, k = 0; i < n; i++)
			if (isLMS[i])
				sa[k++] = i, C[S[i]]--;
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[sa[i + n - m]];
	} else {
		for (int i = 0; i < m; i++)
			sa[i + n - m] = sa[i], C[S[sa[i]]]--;
	}
	fill_n(sa, n - m, 0);
	for (int i = 0; i < m; i++) {
		int lms = sa[i + n - m];
		sa[i + n - m] = 0;
		sa[C[S[lms]]++] = lms;
	}
	induceLS();
}
vi kasai(const char* S, const int* SA, const int* ISA, int n)
{
	vi LCP(n + 1);
	LCP[0] = LCP[n] = -1;
	for (int i = 0, lcp = 0; i < n - 1; i++) {
		while (S[i + lcp] == S[SA[ISA[i] - 1] + lcp])
			lcp++;
		LCP[ISA[i]] = lcp;
		lcp = max(lcp - 1, 0);
	}
	return LCP;
}
struct ESA {
	string s;
	vi SA, ISA, LCP;
};
ESA build_esa(string_view s)
{
	assert(s.back() == '$');
	ESA res;
	res.s = s;
	res.ISA = res.SA = vi(sz(s));
	sais(&res.s[0], &res.SA[0], sz(s));
	for (int i = 0; i < sz(s); i++)
		res.ISA[res.SA[i]] = i;
	res.LCP = kasai(&res.s[0], &res.SA[0], &res.ISA[0], sz(s));
	return res;
}
struct lcp_tree {
	int lcp, lb, rb;
	vector<lcp_tree> children;
};
lcp_tree lcp_interval_tree(const ESA& esa)
{
	const int n = sz(esa.s);
	stack<lcp_tree> st;
	st.emplace(lcp_tree { -1, 0, n, {} });
	for (int i = 1; i <= n; i++) {
		st.emplace(lcp_tree { n, i - 1, n, {} });
		const int lcp = esa.LCP[i];
		int lb = i - 1;
		optional<lcp_tree> last;
		while (lcp < st.top().lcp) {
			st.top().rb = i - 1;
			last = std::move(st.top());
			st.pop();
			lb = last->lb;
			if (lcp <= st.top().lcp) {
				st.top().children.emplace_back(std::move(*last));
				last = nullopt;
			}
		}
		if (lcp > st.top().lcp) {
			st.emplace(lcp_tree { lcp, lb, n, {} });
			if (last)
				st.top().children.emplace_back(std::move(*last));
		}
	}
	return st.top();
}

struct lst {
	struct node {
		int l = -1, r = -1, m = 1e9, max_i = -1;
	};
	int n = 0, sz = 0;
	int size() { return sz; }
	vector<node> nodes;
	void for_each(auto&& f)
	{
		const auto dfs = [&](auto&& self, int ni, int i, int s) -> void {
			if (s == 1) {
				f(i, nodes[ni].m);
				return;
			}
			const int sl = s / 2, sr = s - sl;
			if (int l = nodes[ni].l; l != -1) {
				nodes[l].m = min(nodes[l].m, nodes[ni].m);
				self(self, l, i, sl);
			}
			if (int r = nodes[ni].r; r != -1) {
				nodes[r].m = min(nodes[r].m, nodes[ni].m);
				self(self, r, i + sl, sr);
			}
		};
		if (sz(nodes))
			dfs(dfs, 0, 0, n);
	};
	void insert(int i, int m)
	{
		sz++;
		int s = n, ni = 0;
		while (s > 1) {
			if (ni == sz(nodes))
				nodes.emplace_back();
			nodes[ni].max_i = max(nodes[ni].max_i, i);
			const int sl = s / 2;
			if (int l = nodes[ni].l; l != -1)
				nodes[l].m = min(nodes[l].m, nodes[ni].m);
			if (int r = nodes[ni].r; r != -1)
				nodes[r].m = min(nodes[r].m, nodes[ni].m);
			nodes[ni].m = 1e9;
			if (i < sl) {
				s = sl;
				if (nodes[ni].l == -1)
					nodes[ni].l = sz(nodes);
				ni = nodes[ni].l;
			} else {
				i -= sl, s -= sl;
				if (nodes[ni].r == -1)
					nodes[ni].r = sz(nodes);
				ni = nodes[ni].r;
			}
		}
		nodes.emplace_back(-1, -1, m, i);
	}
	// update all j < i
	void update_min(int i, int v)
	{
		const auto dfs = [&](auto&& self, int ni, int i, int s) {
			if (s == 1) {
				nodes[ni].m = min(nodes[ni].m, v);
				return;
			}
			const int sl = s / 2;
			if (i < sl) {
				if (int l = nodes[ni].l; l != -1)
					self(self, l, i, sl);
			} else {
				if (int l = nodes[ni].l; l != -1)
					nodes[l].m = min(nodes[l].m, v);
				if (int r = nodes[ni].r; r != -1 and i - sl > 0)
					self(self, r, i - sl, s - sl);
			}
		};
		if (i > 0 and sz(nodes) > 0)
			dfs(dfs, 0, i, n);
	}
	optional<int> lower_bound(int i)
	{
		if (nodes.empty() or nodes[0].max_i < i)
			return nullopt;
		int ni = 0, s = n, acc = 0;
		while (s > 1) {
			const int sl = s / 2;
			if (int l = nodes[ni].l; l != -1 and nodes[l].max_i >= i)
				s = sl, ni = nodes[ni].l;
			else
				s -= sl, i -= sl, ni = nodes[ni].r, acc += sl;
		}
		return acc;
	}
};

vi periods(const ESA& esa, const int l)
{
	vi per(sz(esa.s), l);
	auto dfs = [&](auto&& self, const lcp_tree& t) -> lst {
		lst cur;
		cur.n = sz(esa.s);
		if (t.lb == t.rb) {
			cur.insert(esa.SA[t.lb], esa.SA[t.lb] + l);
			return cur;
		}
		for (const lcp_tree& c : t.children) {
			lst tmp = self(self, c);
			if (sz(cur) < sz(tmp))
				swap(cur, tmp);
			tmp.for_each([&](int i, int curm) {
				if (auto it = cur.lower_bound(max(i + 1, i + l - t.lcp)))
					per[i] = min(per[i], *it - i);
				cur.update_min(min(i - 1, i - l + t.lcp) + 1, i);
				cur.insert(i, curm);
			});
		}
		return cur;
	};
	auto t = lcp_interval_tree(esa);
	dfs(dfs, t).for_each([&](int i, int j) {
		per[i] = min(per[i], max(1, j - i));
	});
	return per;
}

int main()
{
	ios::sync_with_stdio(false), cin.tie(nullptr);
	int n, l;
	string s;
	cin >> n >> l >> s;
	s += '$', n++;

	ESA fwd = build_esa(s);
	reverse(&s[0], &s[n - 1]);
	ESA rev = build_esa(s);
	reverse(&s[0], &s[n - 1]);

	vi per = periods(fwd, l);

	vi suffix_match(n); // for each i, find longest prefix of S[i, i + l) that is suffix of S
	{
		vi prefix_match(n);
		prefix_match[n - 2 - 0] = n;
		for (int i = rev.ISA[0] + 1, lcp = n; i < n; i++)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i]);
		for (int i = rev.ISA[0] - 1, lcp = n; i > 0; i--)
			prefix_match[n - 2 - rev.SA[i]] = lcp = min(lcp, rev.LCP[i + 1]);

		for (int p = 0; p < n; p++) {
			prefix_match[p] = min(prefix_match[p], l - 1);
			int i = p - prefix_match[p] + 1;
			assert(0 <= i and i <= n);
			if (i == n)
				continue;
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], prefix_match[p]);
		}

		for (int i = 1; i < n; i++)
			suffix_match[fwd.ISA[i]] = max(suffix_match[fwd.ISA[i]], suffix_match[fwd.ISA[i - 1]] - 1);

		stack<int> st;
		for (int i = 0; i < n; i++) {
			const int j = fwd.SA[i], len = n - 1 - j;
			if (len == 0)
				continue;
			while (not st.empty() and st.top() > fwd.LCP[i])
				st.pop();
			if (len < l) {
				suffix_match[i] = st.empty() ? 0 : st.top();
				per[j] = min(per[j], len - suffix_match[i]);
				st.emplace(len);
			}
		}
	}

	pii res { 0, 0 };
	for (int i = 1; i < n;) {
		int j = i + 1;
		while (j < n and fwd.LCP[j] >= l)
			j++;

		int cnt = j - i;

		if (int dist = suffix_match[j - 1] + l - 1; dist >= l)
			cnt += 1 + (dist - l) / per[fwd.SA[i]];
		res = max(res, pii { cnt, j - 1 });
		i = j;
	}

	s.pop_back();
	cout << s;
	int j = res.second;
	int len = per[fwd.SA[j]];
	for (int i = 0; i < l - 1; i++)
		cout << s[fwd.SA[j] + (suffix_match[j] + i) % len];
	cout << endl;
}
