#include "validate.h"
using namespace std;

#define all(x) ::begin(x), ::end(x)
constexpr int MAX_CHAR = 256;
struct SuffixArray {
	int n;
	vector<int> SA, LCP;
	vector<vector<int>> P;

	SuffixArray(const string& s) : n(ssize(s)), SA(n), LCP(n),
		P(__lg(2 * n - 1) + 1, vector<int>(n)) {
		P[0].assign(all(s));
		iota(all(SA), 0);
		sort(all(SA), [&](int a, int b) {return s[a] < s[b];});
		vector<int> x(n);
		for (int k = 1, c = 1; c < n; k++, c *= 2) {
			iota(all(x), n - c);
			for (int ptr = c; int i : SA) if (i >= c) x[ptr++] = i - c;

			vector<int> cnt(k == 1 ? MAX_CHAR : n);
			for (int i : P[k-1]) cnt[i]++;
			partial_sum(all(cnt), begin(cnt));
            reverse(all(x));
			for (int i : x) SA[--cnt[P[k-1][i]]] = i;
            reverse(all(x));

			auto p = [&](int i) {return i < n ? P[k-1][i] : -1;};
			for (int i = 1; i < n; i++) {
				int a = SA[i-1], b = SA[i];
				P[k][b] = P[k][a] + (p(a) != p(b) || p(a+c) != p(b+c));
		}}
		for (int i = 1; i < n; i++) LCP[i] = lcp(SA[i-1], SA[i]);
	}

	int lcp(int x, int y) {//x & y are text-indices, not SA-indices
		if (x == y) return n - x;
		int res = 0;
		for (int i = ssize(P) - 1; i >= 0 && max(x, y) + res < n; i--) {
			if (P[i][x + res] == P[i][y + res]) res |= 1 << i;
		}
		return res;
	}
};

int check_ans(string ans, string s, int l) {
    int n = ssize(s);
    for (int i=0; i<n; i++) if (s[i] != ans[i]) return -1;

    SuffixArray sa(ans);

    int mx = 1, cur = 1;
    for (int i=1; i<ssize(ans); i++) {
        if (sa.LCP[i] < l) cur = 1;
        else cur++;

        mx = max(mx, cur);
    }

    return mx;
}

int main(int argc, char **argv) {
    OutputValidator::init(argc, argv);
    Multipass::init();
    using namespace OutputValidator;

    Integer n = testIn.integer();
    Integer l = testIn.integer();
    string s = testIn.string();

    string jury_ans = juryAns.string(regex("[a-z]+"), n + l - 1, n + l);
    string team_ans = teamAns.string(regex("[a-z]+"), n + l - 1, n + l);

    int jury = check_ans(jury_ans, s, l);
    int team = check_ans(team_ans, s, l);

    if (jury == -1) {
        juryOut << "Jury answer is invalid, prefix is not s???" << FAIL;
    }
    if (team == -1) {
        juryOut << "Team answer is invalid, prefix is not s" << WA;
    }
    if (team > jury) {
        juryOut << "Team found better answer "
                << team << " > " << jury << " ???" << FAIL;
    }
    if (jury > team) {
        juryOut << "Jury found better answer " 
                << jury << " > " << team << WA;
    }

    teamAns.newline();
    teamAns.eof();
    juryOut << "Ok" << AC;
}
