#include "validate.h"
using namespace InputValidator;
using namespace std;

constexpr int MIN_N = 3;
constexpr int MAX_N = 200'000;
constexpr int MIN_L = 2;

int main(int argc, char **argv) {
    InputValidator::init(argc, argv);

    Integer n = testIn.integer(MIN_N, MAX_N + 1, constraint["n"]);
    testIn.space();
    testIn.integer(MIN_L, n, constraint["l"]);
    testIn.newline();

    testIn.string(regex("[a-z]+"), n, n + 1, constraint["s"]);
    testIn.newline();
    testIn.eof();

    juryOut << AC;
}
